/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_3;

import io.fabric8.kubernetes.api.builder.v4_3.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_3.APIGroupList;
import io.fabric8.kubernetes.api.model.v4_3.APIGroupListFluent;
import io.fabric8.kubernetes.api.model.v4_3.APIGroupListFluentImpl;
import javax.validation.Validator;

public class APIGroupListBuilder
extends APIGroupListFluentImpl<APIGroupListBuilder>
implements VisitableBuilder<APIGroupList, APIGroupListBuilder> {
    APIGroupListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public APIGroupListBuilder() {
        this(true);
    }

    public APIGroupListBuilder(Boolean validationEnabled) {
        this(new APIGroupList(), validationEnabled);
    }

    public APIGroupListBuilder(APIGroupListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public APIGroupListBuilder(APIGroupListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new APIGroupList(), validationEnabled);
    }

    public APIGroupListBuilder(APIGroupListFluent<?> fluent, APIGroupList instance) {
        this(fluent, instance, true);
    }

    public APIGroupListBuilder(APIGroupListFluent<?> fluent, APIGroupList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withGroups(instance.getGroups());
        fluent.withKind(instance.getKind());
        this.validationEnabled = validationEnabled;
    }

    public APIGroupListBuilder(APIGroupList instance) {
        this(instance, (Boolean)true);
    }

    public APIGroupListBuilder(APIGroupList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withGroups(instance.getGroups());
        this.withKind(instance.getKind());
        this.validationEnabled = validationEnabled;
    }

    public APIGroupListBuilder(Validator validator) {
        this(new APIGroupList(), (Boolean)true);
    }

    public APIGroupListBuilder(APIGroupListFluent<?> fluent, APIGroupList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withGroups(instance.getGroups());
        fluent.withKind(instance.getKind());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public APIGroupListBuilder(APIGroupList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withGroups(instance.getGroups());
        this.withKind(instance.getKind());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public APIGroupList build() {
        APIGroupList buildable = new APIGroupList(this.fluent.getApiVersion(), this.fluent.getGroups(), this.fluent.getKind());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIGroupListBuilder that = (APIGroupListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

