/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_2.RouteStatus;
import io.fabric8.openshift.api.model.v4_2.RouteStatusFluent;
import io.fabric8.openshift.api.model.v4_2.RouteStatusFluentImpl;
import javax.validation.Validator;

public class RouteStatusBuilder
extends RouteStatusFluentImpl<RouteStatusBuilder>
implements VisitableBuilder<RouteStatus, RouteStatusBuilder> {
    RouteStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public RouteStatusBuilder() {
        this(true);
    }

    public RouteStatusBuilder(Boolean validationEnabled) {
        this(new RouteStatus(), validationEnabled);
    }

    public RouteStatusBuilder(RouteStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public RouteStatusBuilder(RouteStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RouteStatus(), validationEnabled);
    }

    public RouteStatusBuilder(RouteStatusFluent<?> fluent, RouteStatus instance) {
        this(fluent, instance, true);
    }

    public RouteStatusBuilder(RouteStatusFluent<?> fluent, RouteStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withIngress(instance.getIngress());
        this.validationEnabled = validationEnabled;
    }

    public RouteStatusBuilder(RouteStatus instance) {
        this(instance, (Boolean)true);
    }

    public RouteStatusBuilder(RouteStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withIngress(instance.getIngress());
        this.validationEnabled = validationEnabled;
    }

    public RouteStatusBuilder(Validator validator) {
        this(new RouteStatus(), (Boolean)true);
    }

    public RouteStatusBuilder(RouteStatusFluent<?> fluent, RouteStatus instance, Validator validator) {
        this.fluent = fluent;
        fluent.withIngress(instance.getIngress());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public RouteStatusBuilder(RouteStatus instance, Validator validator) {
        this.fluent = this;
        this.withIngress(instance.getIngress());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public RouteStatus build() {
        RouteStatus buildable = new RouteStatus(this.fluent.getIngress());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteStatusBuilder that = (RouteStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

