/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_2.Nested;
import io.fabric8.kubernetes.api.builder.v4_2.Predicate;
import io.fabric8.kubernetes.api.model.v4_2.ObjectReference;
import io.fabric8.kubernetes.api.model.v4_2.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_2.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v4_2.DeploymentTriggerImageChangeParams;
import io.fabric8.openshift.api.model.v4_2.DeploymentTriggerImageChangeParamsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeploymentTriggerImageChangeParamsFluentImpl<A extends DeploymentTriggerImageChangeParamsFluent<A>>
extends BaseFluent<A>
implements DeploymentTriggerImageChangeParamsFluent<A> {
    private Boolean automatic;
    private List<String> containerNames;
    private ObjectReferenceBuilder from;
    private String lastTriggeredImage;

    public DeploymentTriggerImageChangeParamsFluentImpl() {
    }

    public DeploymentTriggerImageChangeParamsFluentImpl(DeploymentTriggerImageChangeParams instance) {
        this.withAutomatic(instance.getAutomatic());
        this.withContainerNames(instance.getContainerNames());
        this.withFrom(instance.getFrom());
        this.withLastTriggeredImage(instance.getLastTriggeredImage());
    }

    @Override
    public Boolean isAutomatic() {
        return this.automatic;
    }

    @Override
    public A withAutomatic(Boolean automatic) {
        this.automatic = automatic;
        return (A)this;
    }

    @Override
    public Boolean hasAutomatic() {
        return this.automatic != null;
    }

    @Override
    public A withNewAutomatic(String arg1) {
        return this.withAutomatic(new Boolean(arg1));
    }

    @Override
    public A withNewAutomatic(boolean arg1) {
        return this.withAutomatic(new Boolean(arg1));
    }

    @Override
    public A addToContainerNames(int index, String item) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        this.containerNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToContainerNames(int index, String item) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        this.containerNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToContainerNames(String ... items) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.containerNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainerNames(Collection<String> items) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.containerNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainerNames(String ... items) {
        for (String item : items) {
            if (this.containerNames == null) continue;
            this.containerNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainerNames(Collection<String> items) {
        for (String item : items) {
            if (this.containerNames == null) continue;
            this.containerNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getContainerNames() {
        return this.containerNames;
    }

    @Override
    public String getContainerName(int index) {
        return this.containerNames.get(index);
    }

    @Override
    public String getFirstContainerName() {
        return this.containerNames.get(0);
    }

    @Override
    public String getLastContainerName() {
        return this.containerNames.get(this.containerNames.size() - 1);
    }

    @Override
    public String getMatchingContainerName(Predicate<String> predicate) {
        for (String item : this.containerNames) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainerName(Predicate<String> predicate) {
        for (String item : this.containerNames) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainerNames(List<String> containerNames) {
        if (this.containerNames != null) {
            this._visitables.get("containerNames").removeAll(this.containerNames);
        }
        if (containerNames != null) {
            this.containerNames = new ArrayList<String>();
            for (String item : containerNames) {
                this.addToContainerNames(item);
            }
        } else {
            this.containerNames = new ArrayList<String>();
        }
        return (A)this;
    }

    @Override
    public A withContainerNames(String ... containerNames) {
        if (this.containerNames != null) {
            this.containerNames.clear();
        }
        if (containerNames != null) {
            for (String item : containerNames) {
                this.addToContainerNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainerNames() {
        return this.containerNames != null && !this.containerNames.isEmpty();
    }

    @Override
    public A addNewContainerName(String arg1) {
        return this.addToContainerNames(new String(arg1));
    }

    @Override
    public A addNewContainerName(StringBuilder arg1) {
        return this.addToContainerNames(new String(arg1));
    }

    @Override
    public A addNewContainerName(StringBuffer arg1) {
        return this.addToContainerNames(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectReference getFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public A withFrom(ObjectReference from) {
        this._visitables.get("from").remove(this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.get("from").add(this.from);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFrom() {
        return this.from != null;
    }

    @Override
    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : new ObjectReferenceBuilder().build());
    }

    @Override
    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : item);
    }

    @Override
    public String getLastTriggeredImage() {
        return this.lastTriggeredImage;
    }

    @Override
    public A withLastTriggeredImage(String lastTriggeredImage) {
        this.lastTriggeredImage = lastTriggeredImage;
        return (A)this;
    }

    @Override
    public Boolean hasLastTriggeredImage() {
        return this.lastTriggeredImage != null;
    }

    @Override
    public A withNewLastTriggeredImage(String arg1) {
        return this.withLastTriggeredImage(new String(arg1));
    }

    @Override
    public A withNewLastTriggeredImage(StringBuilder arg1) {
        return this.withLastTriggeredImage(new String(arg1));
    }

    @Override
    public A withNewLastTriggeredImage(StringBuffer arg1) {
        return this.withLastTriggeredImage(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentTriggerImageChangeParamsFluentImpl that = (DeploymentTriggerImageChangeParamsFluentImpl)o;
        if (this.automatic != null ? !this.automatic.equals(that.automatic) : that.automatic != null) {
            return false;
        }
        if (this.containerNames != null ? !this.containerNames.equals(that.containerNames) : that.containerNames != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        return !(this.lastTriggeredImage != null ? !this.lastTriggeredImage.equals(that.lastTriggeredImage) : that.lastTriggeredImage != null);
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<DeploymentTriggerImageChangeParamsFluent.FromNested<N>>
    implements DeploymentTriggerImageChangeParamsFluent.FromNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentTriggerImageChangeParamsFluentImpl.this.withFrom(this.builder.build());
        }

        @Override
        public N endFrom() {
            return this.and();
        }
    }
}

