/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_2.DeploymentCondition;
import io.fabric8.openshift.api.model.v4_2.DeploymentConditionFluent;
import io.fabric8.openshift.api.model.v4_2.DeploymentConditionFluentImpl;
import javax.validation.Validator;

public class DeploymentConditionBuilder
extends DeploymentConditionFluentImpl<DeploymentConditionBuilder>
implements VisitableBuilder<DeploymentCondition, DeploymentConditionBuilder> {
    DeploymentConditionFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public DeploymentConditionBuilder() {
        this(true);
    }

    public DeploymentConditionBuilder(Boolean validationEnabled) {
        this(new DeploymentCondition(), validationEnabled);
    }

    public DeploymentConditionBuilder(DeploymentConditionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DeploymentConditionBuilder(DeploymentConditionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DeploymentCondition(), validationEnabled);
    }

    public DeploymentConditionBuilder(DeploymentConditionFluent<?> fluent, DeploymentCondition instance) {
        this(fluent, instance, true);
    }

    public DeploymentConditionBuilder(DeploymentConditionFluent<?> fluent, DeploymentCondition instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLastTransitionTime(instance.getLastTransitionTime());
        fluent.withLastUpdateTime(instance.getLastUpdateTime());
        fluent.withMessage(instance.getMessage());
        fluent.withReason(instance.getReason());
        fluent.withStatus(instance.getStatus());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentConditionBuilder(DeploymentCondition instance) {
        this(instance, (Boolean)true);
    }

    public DeploymentConditionBuilder(DeploymentCondition instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLastTransitionTime(instance.getLastTransitionTime());
        this.withLastUpdateTime(instance.getLastUpdateTime());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.withStatus(instance.getStatus());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentConditionBuilder(Validator validator) {
        this(new DeploymentCondition(), (Boolean)true);
    }

    public DeploymentConditionBuilder(DeploymentConditionFluent<?> fluent, DeploymentCondition instance, Validator validator) {
        this.fluent = fluent;
        fluent.withLastTransitionTime(instance.getLastTransitionTime());
        fluent.withLastUpdateTime(instance.getLastUpdateTime());
        fluent.withMessage(instance.getMessage());
        fluent.withReason(instance.getReason());
        fluent.withStatus(instance.getStatus());
        fluent.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public DeploymentConditionBuilder(DeploymentCondition instance, Validator validator) {
        this.fluent = this;
        this.withLastTransitionTime(instance.getLastTransitionTime());
        this.withLastUpdateTime(instance.getLastUpdateTime());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.withStatus(instance.getStatus());
        this.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public DeploymentCondition build() {
        DeploymentCondition buildable = new DeploymentCondition(this.fluent.getLastTransitionTime(), this.fluent.getLastUpdateTime(), this.fluent.getMessage(), this.fluent.getReason(), this.fluent.getStatus(), this.fluent.getType());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConditionBuilder that = (DeploymentConditionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

