/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_2.handlers;

import io.fabric8.kubernetes.api.model.v4_2.storage.StorageClass;
import io.fabric8.kubernetes.api.model.v4_2.storage.StorageClassBuilder;
import io.fabric8.kubernetes.clnt.v4_2.Config;
import io.fabric8.kubernetes.clnt.v4_2.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_2.Watch;
import io.fabric8.kubernetes.clnt.v4_2.Watcher;
import io.fabric8.kubernetes.clnt.v4_2.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_2.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_2.dsl.internal.StorageClassOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class StorageClassHandler
implements ResourceHandler<StorageClass, StorageClassBuilder> {
    @Override
    public String getKind() {
        return StorageClass.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "storage.k8s.io/v1";
    }

    @Override
    public StorageClass create(OkHttpClient client, Config config, String namespace, StorageClass item) {
        return (StorageClass)new StorageClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new StorageClass[0]);
    }

    @Override
    public StorageClass replace(OkHttpClient client, Config config, String namespace, StorageClass item) {
        return (StorageClass)((Resource)new StorageClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public StorageClass reload(OkHttpClient client, Config config, String namespace, StorageClass item) {
        return (StorageClass)((Gettable)((Resource)new StorageClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public StorageClassBuilder edit(StorageClass item) {
        return new StorageClassBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, StorageClass item) {
        return (Boolean)new StorageClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, StorageClass item, Watcher<StorageClass> watcher) {
        return (Watch)((Resource)new StorageClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, StorageClass item, String resourceVersion, Watcher<StorageClass> watcher) {
        return (Watch)((Resource)new StorageClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public StorageClass waitUntilReady(OkHttpClient client, Config config, String namespace, StorageClass item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (StorageClass)((Resource)new StorageClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public StorageClass waitUntilCondition(OkHttpClient client, Config config, String namespace, StorageClass item, Predicate<StorageClass> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (StorageClass)((Resource)new StorageClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

