/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_2.dsl.internal;

import io.fabric8.kubernetes.api.model.v4_2.DoneableService;
import io.fabric8.kubernetes.api.model.v4_2.Pod;
import io.fabric8.kubernetes.api.model.v4_2.PodList;
import io.fabric8.kubernetes.api.model.v4_2.Service;
import io.fabric8.kubernetes.api.model.v4_2.ServiceBuilder;
import io.fabric8.kubernetes.api.model.v4_2.ServiceFluent;
import io.fabric8.kubernetes.api.model.v4_2.ServiceList;
import io.fabric8.kubernetes.clnt.v4_2.Config;
import io.fabric8.kubernetes.clnt.v4_2.DefaultKubernetesClient;
import io.fabric8.kubernetes.clnt.v4_2.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_2.LocalPortForward;
import io.fabric8.kubernetes.clnt.v4_2.PortForward;
import io.fabric8.kubernetes.clnt.v4_2.ServiceToURLProvider;
import io.fabric8.kubernetes.clnt.v4_2.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v4_2.dsl.ServiceResource;
import io.fabric8.kubernetes.clnt.v4_2.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v4_2.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_2.dsl.internal.EndpointsOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_2.dsl.internal.PodOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_2.utils.URLUtils;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class ServiceOperationsImpl
extends HasMetadataOperation<Service, ServiceList, DoneableService, ServiceResource<Service, DoneableService>>
implements ServiceResource<Service, DoneableService> {
    public ServiceOperationsImpl(OkHttpClient client, Config config) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public ServiceOperationsImpl(OperationContext context) {
        super(context.withPlural("services"));
        this.type = Service.class;
        this.listType = ServiceList.class;
        this.doneableType = DoneableService.class;
    }

    public ServiceOperationsImpl newInstance(OperationContext context) {
        return new ServiceOperationsImpl(context);
    }

    @Override
    public Service replace(Service item) {
        try {
            Service old = (Service)this.getMandatory();
            return super.replace(((ServiceBuilder)((ServiceFluent.SpecNested)new ServiceBuilder(item).editSpec().withClusterIP(old.getSpec().getClusterIP())).endSpec()).build());
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("replace"), (Throwable)e);
        }
    }

    @Override
    public Service patch(Service item) {
        try {
            Service old = (Service)this.getMandatory();
            return super.patch(((ServiceBuilder)((ServiceFluent.SpecNested)new ServiceBuilder(item).editSpec().withClusterIP(old.getSpec().getClusterIP())).endSpec()).build());
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("patch"), (Throwable)e);
        }
    }

    @Override
    public Service waitUntilReady(long amount, TimeUnit timeUnit) throws InterruptedException {
        long started = System.nanoTime();
        super.waitUntilReady(amount, timeUnit);
        long alreadySpent = System.nanoTime() - started;
        long remaining = Math.max(10000L, timeUnit.toNanos(amount) - alreadySpent);
        EndpointsOperationsImpl endpointsOperation = new EndpointsOperationsImpl(this.context);
        endpointsOperation.waitUntilReady(remaining, TimeUnit.MILLISECONDS);
        return (Service)this.get();
    }

    @Override
    public String getURL(String portName) {
        String clusterIP = ((Service)this.getMandatory()).getSpec().getClusterIP();
        if ("None".equals(clusterIP)) {
            throw new IllegalStateException("Service: " + ((Service)this.getMandatory()).getMetadata().getName() + " in namespace " + this.namespace + " is head-less. Search for endpoints instead");
        }
        return this.getUrlHelper(portName);
    }

    private String getUrlHelper(String portName) {
        ServiceLoader<ServiceToURLProvider> urlProvider = ServiceLoader.load(ServiceToURLProvider.class, Thread.currentThread().getContextClassLoader());
        Iterator<ServiceToURLProvider> iterator = urlProvider.iterator();
        ArrayList<ServiceToURLProvider> servicesList = new ArrayList<ServiceToURLProvider>();
        while (iterator.hasNext()) {
            servicesList.add(iterator.next());
        }
        Collections.sort(servicesList, new ServiceToUrlSortComparator());
        for (ServiceToURLProvider serviceToURLProvider : servicesList) {
            String url = serviceToURLProvider.getURL((Service)this.getMandatory(), portName, this.namespace, new DefaultKubernetesClient(this.client, this.getConfig()));
            if (url == null || !URLUtils.isValidURL(url)) continue;
            return url;
        }
        return null;
    }

    private Pod matchingPod() {
        Service item = (Service)this.fromServer().get();
        Map<String, String> labels = item.getSpec().getSelector();
        PodList list = (PodList)new PodOperationsImpl(this.client, this.config).withLabels((Map)labels).list();
        return (Pod)list.getItems().stream().findFirst().orElseThrow(() -> new IllegalStateException("Could not find matching pod for service:" + item + "."));
    }

    @Override
    public PortForward portForward(int port, ReadableByteChannel in, WritableByteChannel out) {
        Pod m = this.matchingPod();
        return (PortForward)((PodResource)new PodOperationsImpl(this.client, this.config).inNamespace(m.getMetadata().getNamespace()).withName(m.getMetadata().getName())).portForward(port, in, out);
    }

    @Override
    public LocalPortForward portForward(int port, int localPort) {
        Pod m = this.matchingPod();
        return (LocalPortForward)((PodResource)new PodOperationsImpl(this.client, this.config).inNamespace(m.getMetadata().getNamespace()).withName(m.getMetadata().getName())).portForward(port, localPort);
    }

    @Override
    public LocalPortForward portForward(int port) {
        Pod m = this.matchingPod();
        return (LocalPortForward)((PodResource)new PodOperationsImpl(this.client, this.config).inNamespace(m.getMetadata().getNamespace()).withName(m.getMetadata().getName())).portForward(port);
    }

    public class ServiceToUrlSortComparator
    implements Comparator<ServiceToURLProvider> {
        @Override
        public int compare(ServiceToURLProvider first, ServiceToURLProvider second) {
            return first.getPriority() - second.getPriority();
        }
    }
}

