/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_2.dsl.internal;

import io.fabric8.kubernetes.api.model.v4_2.Container;
import io.fabric8.kubernetes.api.model.v4_2.ContainerBuilder;
import io.fabric8.kubernetes.api.model.v4_2.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.v4_2.apps.DoneableReplicaSet;
import io.fabric8.kubernetes.api.model.v4_2.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.v4_2.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.v4_2.apps.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.v4_2.apps.ReplicaSetList;
import io.fabric8.kubernetes.api.model.v4_2.apps.ReplicaSetSpecFluent;
import io.fabric8.kubernetes.clnt.v4_2.Config;
import io.fabric8.kubernetes.clnt.v4_2.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_2.dsl.ImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v4_2.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v4_2.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v4_2.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_2.dsl.internal.ReplicaSetRollingUpdater;
import io.fabric8.kubernetes.clnt.v4_2.dsl.internal.RollableScalableResourceOperation;
import io.fabric8.kubernetes.clnt.v4_2.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.clnt.v4_2.dsl.internal.RollingUpdater;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class ReplicaSetOperationsImpl
extends RollableScalableResourceOperation<ReplicaSet, ReplicaSetList, DoneableReplicaSet, RollableScalableResource<ReplicaSet, DoneableReplicaSet>>
implements TimeoutImageEditReplacePatchable<ReplicaSet, ReplicaSet, DoneableReplicaSet> {
    public ReplicaSetOperationsImpl(OkHttpClient client, Config config) {
        this(new RollingOperationContext().withOkhttpClient(client).withConfig(config));
    }

    public ReplicaSetOperationsImpl(RollingOperationContext context) {
        super(context.withApiGroupName("apps").withApiGroupVersion("v1").withPlural("replicasets"));
        this.type = ReplicaSet.class;
        this.listType = ReplicaSetList.class;
        this.doneableType = DoneableReplicaSet.class;
    }

    public ReplicaSetOperationsImpl newInstance(OperationContext context) {
        return new ReplicaSetOperationsImpl((RollingOperationContext)context);
    }

    @Override
    public ReplicaSet updateImage(String image) {
        ReplicaSet oldRC = (ReplicaSet)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing replica set doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() == 0) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container updatedContainer = ((ContainerBuilder)new ContainerBuilder(oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next()).withImage(image)).build();
        ReplicaSetBuilder newRCBuilder = new ReplicaSetBuilder(oldRC);
        ((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((ReplicaSetBuilder)((ReplicaSetFluent.MetadataNested)newRCBuilder.editMetadata().withResourceVersion(null)).endMetadata()).editSpec().editTemplate().editSpec().withContainers(Collections.singletonList(updatedContainer))).endSpec()).endTemplate()).endSpec();
        return new ReplicaSetRollingUpdater(this.client, this.config, this.namespace).rollUpdate(oldRC, newRCBuilder.build());
    }

    @Override
    ReplicaSet withReplicas(int count) {
        return ((DoneableReplicaSet)((ReplicaSetFluent.SpecNested)((DoneableReplicaSet)this.cascading(false).edit()).editSpec().withReplicas(count)).endSpec()).done();
    }

    @Override
    RollingUpdater<ReplicaSet, ReplicaSetList, DoneableReplicaSet> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new ReplicaSetRollingUpdater(this.client, this.config, this.getNamespace(), rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    int getCurrentReplicas(ReplicaSet current) {
        return current.getStatus().getReplicas();
    }

    @Override
    int getDesiredReplicas(ReplicaSet item) {
        return item.getSpec().getReplicas();
    }

    @Override
    long getObservedGeneration(ReplicaSet current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    @Override
    public TimeoutImageEditReplacePatchable rolling() {
        return new ReplicaSetOperationsImpl(((RollingOperationContext)this.context).withRolling(true));
    }

    @Override
    public ImageEditReplacePatchable<ReplicaSet, ReplicaSet, DoneableReplicaSet> withTimeout(long timeout, TimeUnit unit) {
        return new ReplicaSetOperationsImpl(((RollingOperationContext)this.context).withRollingTimeout(unit.toMillis(timeout)).withRollingTimeUnit(TimeUnit.MILLISECONDS));
    }

    @Override
    public ImageEditReplacePatchable<ReplicaSet, ReplicaSet, DoneableReplicaSet> withTimeoutInMillis(long timeoutInMillis) {
        return new ReplicaSetOperationsImpl(((RollingOperationContext)this.context).withRollingTimeout(timeoutInMillis));
    }
}

