/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_2.MetricStatus;
import io.fabric8.kubernetes.api.model.v4_2.MetricStatusFluent;
import io.fabric8.kubernetes.api.model.v4_2.MetricStatusFluentImpl;
import javax.validation.Validator;

public class MetricStatusBuilder
extends MetricStatusFluentImpl<MetricStatusBuilder>
implements VisitableBuilder<MetricStatus, MetricStatusBuilder> {
    MetricStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public MetricStatusBuilder() {
        this(true);
    }

    public MetricStatusBuilder(Boolean validationEnabled) {
        this(new MetricStatus(), validationEnabled);
    }

    public MetricStatusBuilder(MetricStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public MetricStatusBuilder(MetricStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new MetricStatus(), validationEnabled);
    }

    public MetricStatusBuilder(MetricStatusFluent<?> fluent, MetricStatus instance) {
        this(fluent, instance, true);
    }

    public MetricStatusBuilder(MetricStatusFluent<?> fluent, MetricStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withExternal(instance.getExternal());
        fluent.withObject(instance.getObject());
        fluent.withPods(instance.getPods());
        fluent.withResource(instance.getResource());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public MetricStatusBuilder(MetricStatus instance) {
        this(instance, (Boolean)true);
    }

    public MetricStatusBuilder(MetricStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withExternal(instance.getExternal());
        this.withObject(instance.getObject());
        this.withPods(instance.getPods());
        this.withResource(instance.getResource());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public MetricStatusBuilder(Validator validator) {
        this(new MetricStatus(), (Boolean)true);
    }

    public MetricStatusBuilder(MetricStatusFluent<?> fluent, MetricStatus instance, Validator validator) {
        this.fluent = fluent;
        fluent.withExternal(instance.getExternal());
        fluent.withObject(instance.getObject());
        fluent.withPods(instance.getPods());
        fluent.withResource(instance.getResource());
        fluent.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public MetricStatusBuilder(MetricStatus instance, Validator validator) {
        this.fluent = this;
        this.withExternal(instance.getExternal());
        this.withObject(instance.getObject());
        this.withPods(instance.getPods());
        this.withResource(instance.getResource());
        this.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public MetricStatus build() {
        MetricStatus buildable = new MetricStatus(this.fluent.getExternal(), this.fluent.getObject(), this.fluent.getPods(), this.fluent.getResource(), this.fluent.getType());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetricStatusBuilder that = (MetricStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

