/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_2.Nested;
import io.fabric8.kubernetes.api.builder.v4_2.Predicate;
import io.fabric8.kubernetes.api.model.v4_2.Initializer;
import io.fabric8.kubernetes.api.model.v4_2.InitializerBuilder;
import io.fabric8.kubernetes.api.model.v4_2.InitializerFluentImpl;
import io.fabric8.kubernetes.api.model.v4_2.Initializers;
import io.fabric8.kubernetes.api.model.v4_2.InitializersFluent;
import io.fabric8.kubernetes.api.model.v4_2.Status;
import io.fabric8.kubernetes.api.model.v4_2.StatusBuilder;
import io.fabric8.kubernetes.api.model.v4_2.StatusFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InitializersFluentImpl<A extends InitializersFluent<A>>
extends BaseFluent<A>
implements InitializersFluent<A> {
    private List<InitializerBuilder> pending;
    private StatusBuilder result;

    public InitializersFluentImpl() {
    }

    public InitializersFluentImpl(Initializers instance) {
        this.withPending(instance.getPending());
        this.withResult(instance.getResult());
    }

    @Override
    public A addToPending(int index, Initializer item) {
        if (this.pending == null) {
            this.pending = new ArrayList<InitializerBuilder>();
        }
        InitializerBuilder builder = new InitializerBuilder(item);
        this._visitables.get("pending").add(index >= 0 ? index : this._visitables.get("pending").size(), builder);
        this.pending.add(index >= 0 ? index : this.pending.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPending(int index, Initializer item) {
        if (this.pending == null) {
            this.pending = new ArrayList<InitializerBuilder>();
        }
        InitializerBuilder builder = new InitializerBuilder(item);
        if (index < 0 || index >= this._visitables.get("pending").size()) {
            this._visitables.get("pending").add(builder);
        } else {
            this._visitables.get("pending").set(index, builder);
        }
        if (index < 0 || index >= this.pending.size()) {
            this.pending.add(builder);
        } else {
            this.pending.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPending(Initializer ... items) {
        if (this.pending == null) {
            this.pending = new ArrayList<InitializerBuilder>();
        }
        for (Initializer item : items) {
            InitializerBuilder builder = new InitializerBuilder(item);
            this._visitables.get("pending").add(builder);
            this.pending.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPending(Collection<Initializer> items) {
        if (this.pending == null) {
            this.pending = new ArrayList<InitializerBuilder>();
        }
        for (Initializer item : items) {
            InitializerBuilder builder = new InitializerBuilder(item);
            this._visitables.get("pending").add(builder);
            this.pending.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPending(Initializer ... items) {
        for (Initializer item : items) {
            InitializerBuilder builder = new InitializerBuilder(item);
            this._visitables.get("pending").remove(builder);
            if (this.pending == null) continue;
            this.pending.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPending(Collection<Initializer> items) {
        for (Initializer item : items) {
            InitializerBuilder builder = new InitializerBuilder(item);
            this._visitables.get("pending").remove(builder);
            if (this.pending == null) continue;
            this.pending.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Initializer> getPending() {
        return InitializersFluentImpl.build(this.pending);
    }

    @Override
    public List<Initializer> buildPending() {
        return InitializersFluentImpl.build(this.pending);
    }

    @Override
    public Initializer buildPending(int index) {
        return this.pending.get(index).build();
    }

    @Override
    public Initializer buildFirstPending() {
        return this.pending.get(0).build();
    }

    @Override
    public Initializer buildLastPending() {
        return this.pending.get(this.pending.size() - 1).build();
    }

    @Override
    public Initializer buildMatchingPending(Predicate<InitializerBuilder> predicate) {
        for (InitializerBuilder item : this.pending) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPending(Predicate<InitializerBuilder> predicate) {
        for (InitializerBuilder item : this.pending) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPending(List<Initializer> pending) {
        if (this.pending != null) {
            this._visitables.get("pending").removeAll(this.pending);
        }
        if (pending != null) {
            this.pending = new ArrayList<InitializerBuilder>();
            for (Initializer item : pending) {
                this.addToPending(item);
            }
        } else {
            this.pending = new ArrayList<InitializerBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withPending(Initializer ... pending) {
        if (this.pending != null) {
            this.pending.clear();
        }
        if (pending != null) {
            for (Initializer item : pending) {
                this.addToPending(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPending() {
        return this.pending != null && !this.pending.isEmpty();
    }

    @Override
    public A addNewPending(String name) {
        return this.addToPending(new Initializer(name));
    }

    @Override
    public InitializersFluent.PendingNested<A> addNewPending() {
        return new PendingNestedImpl();
    }

    @Override
    public InitializersFluent.PendingNested<A> addNewPendingLike(Initializer item) {
        return new PendingNestedImpl(-1, item);
    }

    @Override
    public InitializersFluent.PendingNested<A> setNewPendingLike(int index, Initializer item) {
        return new PendingNestedImpl(index, item);
    }

    @Override
    public InitializersFluent.PendingNested<A> editPending(int index) {
        if (this.pending.size() <= index) {
            throw new RuntimeException("Can't edit pending. Index exceeds size.");
        }
        return this.setNewPendingLike(index, this.buildPending(index));
    }

    @Override
    public InitializersFluent.PendingNested<A> editFirstPending() {
        if (this.pending.size() == 0) {
            throw new RuntimeException("Can't edit first pending. The list is empty.");
        }
        return this.setNewPendingLike(0, this.buildPending(0));
    }

    @Override
    public InitializersFluent.PendingNested<A> editLastPending() {
        int index = this.pending.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last pending. The list is empty.");
        }
        return this.setNewPendingLike(index, this.buildPending(index));
    }

    @Override
    public InitializersFluent.PendingNested<A> editMatchingPending(Predicate<InitializerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.pending.size(); ++i) {
            if (!predicate.apply(this.pending.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching pending. No match found.");
        }
        return this.setNewPendingLike(index, this.buildPending(index));
    }

    @Override
    @Deprecated
    public Status getResult() {
        return this.result != null ? this.result.build() : null;
    }

    @Override
    public Status buildResult() {
        return this.result != null ? this.result.build() : null;
    }

    @Override
    public A withResult(Status result) {
        this._visitables.get("result").remove(this.result);
        if (result != null) {
            this.result = new StatusBuilder(result);
            this._visitables.get("result").add(this.result);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResult() {
        return this.result != null;
    }

    @Override
    public InitializersFluent.ResultNested<A> withNewResult() {
        return new ResultNestedImpl();
    }

    @Override
    public InitializersFluent.ResultNested<A> withNewResultLike(Status item) {
        return new ResultNestedImpl(item);
    }

    @Override
    public InitializersFluent.ResultNested<A> editResult() {
        return this.withNewResultLike(this.getResult());
    }

    @Override
    public InitializersFluent.ResultNested<A> editOrNewResult() {
        return this.withNewResultLike(this.getResult() != null ? this.getResult() : new StatusBuilder().build());
    }

    @Override
    public InitializersFluent.ResultNested<A> editOrNewResultLike(Status item) {
        return this.withNewResultLike(this.getResult() != null ? this.getResult() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InitializersFluentImpl that = (InitializersFluentImpl)o;
        if (this.pending != null ? !this.pending.equals(that.pending) : that.pending != null) {
            return false;
        }
        return !(this.result != null ? !this.result.equals(that.result) : that.result != null);
    }

    public class ResultNestedImpl<N>
    extends StatusFluentImpl<InitializersFluent.ResultNested<N>>
    implements InitializersFluent.ResultNested<N>,
    Nested<N> {
        private final StatusBuilder builder;

        ResultNestedImpl(Status item) {
            this.builder = new StatusBuilder(this, item);
        }

        ResultNestedImpl() {
            this.builder = new StatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)InitializersFluentImpl.this.withResult(this.builder.build());
        }

        @Override
        public N endResult() {
            return this.and();
        }
    }

    public class PendingNestedImpl<N>
    extends InitializerFluentImpl<InitializersFluent.PendingNested<N>>
    implements InitializersFluent.PendingNested<N>,
    Nested<N> {
        private final InitializerBuilder builder;
        private final int index;

        PendingNestedImpl(int index, Initializer item) {
            this.index = index;
            this.builder = new InitializerBuilder(this, item);
        }

        PendingNestedImpl() {
            this.index = -1;
            this.builder = new InitializerBuilder(this);
        }

        @Override
        public N and() {
            return (N)InitializersFluentImpl.this.setToPending(this.index, this.builder.build());
        }

        @Override
        public N endPending() {
            return this.and();
        }
    }
}

