/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_2.Nested;
import io.fabric8.kubernetes.api.builder.v4_2.Predicate;
import io.fabric8.kubernetes.api.model.v4_2.ObjectReference;
import io.fabric8.kubernetes.api.model.v4_2.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_2.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v4_2.BuildStatus;
import io.fabric8.openshift.api.model.v4_2.BuildStatusFluent;
import io.fabric8.openshift.api.model.v4_2.BuildStatusOutput;
import io.fabric8.openshift.api.model.v4_2.BuildStatusOutputBuilder;
import io.fabric8.openshift.api.model.v4_2.BuildStatusOutputFluentImpl;
import io.fabric8.openshift.api.model.v4_2.StageInfo;
import io.fabric8.openshift.api.model.v4_2.StageInfoBuilder;
import io.fabric8.openshift.api.model.v4_2.StageInfoFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BuildStatusFluentImpl<A extends BuildStatusFluent<A>>
extends BaseFluent<A>
implements BuildStatusFluent<A> {
    private Boolean cancelled;
    private String completionTimestamp;
    private ObjectReferenceBuilder config;
    private Long duration;
    private String logSnippet;
    private String message;
    private BuildStatusOutputBuilder output;
    private String outputDockerImageReference;
    private String phase;
    private String reason;
    private List<StageInfoBuilder> stages;
    private String startTimestamp;

    public BuildStatusFluentImpl() {
    }

    public BuildStatusFluentImpl(BuildStatus instance) {
        this.withCancelled(instance.getCancelled());
        this.withCompletionTimestamp(instance.getCompletionTimestamp());
        this.withConfig(instance.getConfig());
        this.withDuration(instance.getDuration());
        this.withLogSnippet(instance.getLogSnippet());
        this.withMessage(instance.getMessage());
        this.withOutput(instance.getOutput());
        this.withOutputDockerImageReference(instance.getOutputDockerImageReference());
        this.withPhase(instance.getPhase());
        this.withReason(instance.getReason());
        this.withStages(instance.getStages());
        this.withStartTimestamp(instance.getStartTimestamp());
    }

    @Override
    public Boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public A withCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
        return (A)this;
    }

    @Override
    public Boolean hasCancelled() {
        return this.cancelled != null;
    }

    @Override
    public A withNewCancelled(String arg1) {
        return this.withCancelled(new Boolean(arg1));
    }

    @Override
    public A withNewCancelled(boolean arg1) {
        return this.withCancelled(new Boolean(arg1));
    }

    @Override
    public String getCompletionTimestamp() {
        return this.completionTimestamp;
    }

    @Override
    public A withCompletionTimestamp(String completionTimestamp) {
        this.completionTimestamp = completionTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasCompletionTimestamp() {
        return this.completionTimestamp != null;
    }

    @Override
    public A withNewCompletionTimestamp(String arg1) {
        return this.withCompletionTimestamp(new String(arg1));
    }

    @Override
    public A withNewCompletionTimestamp(StringBuilder arg1) {
        return this.withCompletionTimestamp(new String(arg1));
    }

    @Override
    public A withNewCompletionTimestamp(StringBuffer arg1) {
        return this.withCompletionTimestamp(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectReference getConfig() {
        return this.config != null ? this.config.build() : null;
    }

    @Override
    public ObjectReference buildConfig() {
        return this.config != null ? this.config.build() : null;
    }

    @Override
    public A withConfig(ObjectReference config) {
        this._visitables.get("config").remove(this.config);
        if (config != null) {
            this.config = new ObjectReferenceBuilder(config);
            this._visitables.get("config").add(this.config);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfig() {
        return this.config != null;
    }

    @Override
    public BuildStatusFluent.ConfigNested<A> withNewConfig() {
        return new ConfigNestedImpl();
    }

    @Override
    public BuildStatusFluent.ConfigNested<A> withNewConfigLike(ObjectReference item) {
        return new ConfigNestedImpl(item);
    }

    @Override
    public BuildStatusFluent.ConfigNested<A> editConfig() {
        return this.withNewConfigLike(this.getConfig());
    }

    @Override
    public BuildStatusFluent.ConfigNested<A> editOrNewConfig() {
        return this.withNewConfigLike(this.getConfig() != null ? this.getConfig() : new ObjectReferenceBuilder().build());
    }

    @Override
    public BuildStatusFluent.ConfigNested<A> editOrNewConfigLike(ObjectReference item) {
        return this.withNewConfigLike(this.getConfig() != null ? this.getConfig() : item);
    }

    @Override
    public Long getDuration() {
        return this.duration;
    }

    @Override
    public A withDuration(Long duration) {
        this.duration = duration;
        return (A)this;
    }

    @Override
    public Boolean hasDuration() {
        return this.duration != null;
    }

    @Override
    public String getLogSnippet() {
        return this.logSnippet;
    }

    @Override
    public A withLogSnippet(String logSnippet) {
        this.logSnippet = logSnippet;
        return (A)this;
    }

    @Override
    public Boolean hasLogSnippet() {
        return this.logSnippet != null;
    }

    @Override
    public A withNewLogSnippet(String arg1) {
        return this.withLogSnippet(new String(arg1));
    }

    @Override
    public A withNewLogSnippet(StringBuilder arg1) {
        return this.withLogSnippet(new String(arg1));
    }

    @Override
    public A withNewLogSnippet(StringBuffer arg1) {
        return this.withLogSnippet(new String(arg1));
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    @Override
    public Boolean hasMessage() {
        return this.message != null;
    }

    @Override
    public A withNewMessage(String arg1) {
        return this.withMessage(new String(arg1));
    }

    @Override
    public A withNewMessage(StringBuilder arg1) {
        return this.withMessage(new String(arg1));
    }

    @Override
    public A withNewMessage(StringBuffer arg1) {
        return this.withMessage(new String(arg1));
    }

    @Override
    @Deprecated
    public BuildStatusOutput getOutput() {
        return this.output != null ? this.output.build() : null;
    }

    @Override
    public BuildStatusOutput buildOutput() {
        return this.output != null ? this.output.build() : null;
    }

    @Override
    public A withOutput(BuildStatusOutput output) {
        this._visitables.get("output").remove(this.output);
        if (output != null) {
            this.output = new BuildStatusOutputBuilder(output);
            this._visitables.get("output").add(this.output);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOutput() {
        return this.output != null;
    }

    @Override
    public BuildStatusFluent.OutputNested<A> withNewOutput() {
        return new OutputNestedImpl();
    }

    @Override
    public BuildStatusFluent.OutputNested<A> withNewOutputLike(BuildStatusOutput item) {
        return new OutputNestedImpl(item);
    }

    @Override
    public BuildStatusFluent.OutputNested<A> editOutput() {
        return this.withNewOutputLike(this.getOutput());
    }

    @Override
    public BuildStatusFluent.OutputNested<A> editOrNewOutput() {
        return this.withNewOutputLike(this.getOutput() != null ? this.getOutput() : new BuildStatusOutputBuilder().build());
    }

    @Override
    public BuildStatusFluent.OutputNested<A> editOrNewOutputLike(BuildStatusOutput item) {
        return this.withNewOutputLike(this.getOutput() != null ? this.getOutput() : item);
    }

    @Override
    public String getOutputDockerImageReference() {
        return this.outputDockerImageReference;
    }

    @Override
    public A withOutputDockerImageReference(String outputDockerImageReference) {
        this.outputDockerImageReference = outputDockerImageReference;
        return (A)this;
    }

    @Override
    public Boolean hasOutputDockerImageReference() {
        return this.outputDockerImageReference != null;
    }

    @Override
    public A withNewOutputDockerImageReference(String arg1) {
        return this.withOutputDockerImageReference(new String(arg1));
    }

    @Override
    public A withNewOutputDockerImageReference(StringBuilder arg1) {
        return this.withOutputDockerImageReference(new String(arg1));
    }

    @Override
    public A withNewOutputDockerImageReference(StringBuffer arg1) {
        return this.withOutputDockerImageReference(new String(arg1));
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    @Override
    public Boolean hasPhase() {
        return this.phase != null;
    }

    @Override
    public A withNewPhase(String arg1) {
        return this.withPhase(new String(arg1));
    }

    @Override
    public A withNewPhase(StringBuilder arg1) {
        return this.withPhase(new String(arg1));
    }

    @Override
    public A withNewPhase(StringBuffer arg1) {
        return this.withPhase(new String(arg1));
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    @Override
    public Boolean hasReason() {
        return this.reason != null;
    }

    @Override
    public A withNewReason(String arg1) {
        return this.withReason(new String(arg1));
    }

    @Override
    public A withNewReason(StringBuilder arg1) {
        return this.withReason(new String(arg1));
    }

    @Override
    public A withNewReason(StringBuffer arg1) {
        return this.withReason(new String(arg1));
    }

    @Override
    public A addToStages(int index, StageInfo item) {
        if (this.stages == null) {
            this.stages = new ArrayList<StageInfoBuilder>();
        }
        StageInfoBuilder builder = new StageInfoBuilder(item);
        this._visitables.get("stages").add(index >= 0 ? index : this._visitables.get("stages").size(), builder);
        this.stages.add(index >= 0 ? index : this.stages.size(), builder);
        return (A)this;
    }

    @Override
    public A setToStages(int index, StageInfo item) {
        if (this.stages == null) {
            this.stages = new ArrayList<StageInfoBuilder>();
        }
        StageInfoBuilder builder = new StageInfoBuilder(item);
        if (index < 0 || index >= this._visitables.get("stages").size()) {
            this._visitables.get("stages").add(builder);
        } else {
            this._visitables.get("stages").set(index, builder);
        }
        if (index < 0 || index >= this.stages.size()) {
            this.stages.add(builder);
        } else {
            this.stages.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToStages(StageInfo ... items) {
        if (this.stages == null) {
            this.stages = new ArrayList<StageInfoBuilder>();
        }
        for (StageInfo item : items) {
            StageInfoBuilder builder = new StageInfoBuilder(item);
            this._visitables.get("stages").add(builder);
            this.stages.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToStages(Collection<StageInfo> items) {
        if (this.stages == null) {
            this.stages = new ArrayList<StageInfoBuilder>();
        }
        for (StageInfo item : items) {
            StageInfoBuilder builder = new StageInfoBuilder(item);
            this._visitables.get("stages").add(builder);
            this.stages.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromStages(StageInfo ... items) {
        for (StageInfo item : items) {
            StageInfoBuilder builder = new StageInfoBuilder(item);
            this._visitables.get("stages").remove(builder);
            if (this.stages == null) continue;
            this.stages.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromStages(Collection<StageInfo> items) {
        for (StageInfo item : items) {
            StageInfoBuilder builder = new StageInfoBuilder(item);
            this._visitables.get("stages").remove(builder);
            if (this.stages == null) continue;
            this.stages.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<StageInfo> getStages() {
        return BuildStatusFluentImpl.build(this.stages);
    }

    @Override
    public List<StageInfo> buildStages() {
        return BuildStatusFluentImpl.build(this.stages);
    }

    @Override
    public StageInfo buildStage(int index) {
        return this.stages.get(index).build();
    }

    @Override
    public StageInfo buildFirstStage() {
        return this.stages.get(0).build();
    }

    @Override
    public StageInfo buildLastStage() {
        return this.stages.get(this.stages.size() - 1).build();
    }

    @Override
    public StageInfo buildMatchingStage(Predicate<StageInfoBuilder> predicate) {
        for (StageInfoBuilder item : this.stages) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingStage(Predicate<StageInfoBuilder> predicate) {
        for (StageInfoBuilder item : this.stages) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withStages(List<StageInfo> stages) {
        if (this.stages != null) {
            this._visitables.get("stages").removeAll(this.stages);
        }
        if (stages != null) {
            this.stages = new ArrayList<StageInfoBuilder>();
            for (StageInfo item : stages) {
                this.addToStages(item);
            }
        } else {
            this.stages = new ArrayList<StageInfoBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withStages(StageInfo ... stages) {
        if (this.stages != null) {
            this.stages.clear();
        }
        if (stages != null) {
            for (StageInfo item : stages) {
                this.addToStages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasStages() {
        return this.stages != null && !this.stages.isEmpty();
    }

    @Override
    public BuildStatusFluent.StagesNested<A> addNewStage() {
        return new StagesNestedImpl();
    }

    @Override
    public BuildStatusFluent.StagesNested<A> addNewStageLike(StageInfo item) {
        return new StagesNestedImpl(-1, item);
    }

    @Override
    public BuildStatusFluent.StagesNested<A> setNewStageLike(int index, StageInfo item) {
        return new StagesNestedImpl(index, item);
    }

    @Override
    public BuildStatusFluent.StagesNested<A> editStage(int index) {
        if (this.stages.size() <= index) {
            throw new RuntimeException("Can't edit stages. Index exceeds size.");
        }
        return this.setNewStageLike(index, this.buildStage(index));
    }

    @Override
    public BuildStatusFluent.StagesNested<A> editFirstStage() {
        if (this.stages.size() == 0) {
            throw new RuntimeException("Can't edit first stages. The list is empty.");
        }
        return this.setNewStageLike(0, this.buildStage(0));
    }

    @Override
    public BuildStatusFluent.StagesNested<A> editLastStage() {
        int index = this.stages.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last stages. The list is empty.");
        }
        return this.setNewStageLike(index, this.buildStage(index));
    }

    @Override
    public BuildStatusFluent.StagesNested<A> editMatchingStage(Predicate<StageInfoBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.stages.size(); ++i) {
            if (!predicate.apply(this.stages.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching stages. No match found.");
        }
        return this.setNewStageLike(index, this.buildStage(index));
    }

    @Override
    public String getStartTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public A withStartTimestamp(String startTimestamp) {
        this.startTimestamp = startTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasStartTimestamp() {
        return this.startTimestamp != null;
    }

    @Override
    public A withNewStartTimestamp(String arg1) {
        return this.withStartTimestamp(new String(arg1));
    }

    @Override
    public A withNewStartTimestamp(StringBuilder arg1) {
        return this.withStartTimestamp(new String(arg1));
    }

    @Override
    public A withNewStartTimestamp(StringBuffer arg1) {
        return this.withStartTimestamp(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildStatusFluentImpl that = (BuildStatusFluentImpl)o;
        if (this.cancelled != null ? !this.cancelled.equals(that.cancelled) : that.cancelled != null) {
            return false;
        }
        if (this.completionTimestamp != null ? !this.completionTimestamp.equals(that.completionTimestamp) : that.completionTimestamp != null) {
            return false;
        }
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        if (this.duration != null ? !this.duration.equals(that.duration) : that.duration != null) {
            return false;
        }
        if (this.logSnippet != null ? !this.logSnippet.equals(that.logSnippet) : that.logSnippet != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.output != null ? !this.output.equals(that.output) : that.output != null) {
            return false;
        }
        if (this.outputDockerImageReference != null ? !this.outputDockerImageReference.equals(that.outputDockerImageReference) : that.outputDockerImageReference != null) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        if (this.stages != null ? !this.stages.equals(that.stages) : that.stages != null) {
            return false;
        }
        return !(this.startTimestamp != null ? !this.startTimestamp.equals(that.startTimestamp) : that.startTimestamp != null);
    }

    public class StagesNestedImpl<N>
    extends StageInfoFluentImpl<BuildStatusFluent.StagesNested<N>>
    implements BuildStatusFluent.StagesNested<N>,
    Nested<N> {
        private final StageInfoBuilder builder;
        private final int index;

        StagesNestedImpl(int index, StageInfo item) {
            this.index = index;
            this.builder = new StageInfoBuilder(this, item);
        }

        StagesNestedImpl() {
            this.index = -1;
            this.builder = new StageInfoBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildStatusFluentImpl.this.setToStages(this.index, this.builder.build());
        }

        @Override
        public N endStage() {
            return this.and();
        }
    }

    public class OutputNestedImpl<N>
    extends BuildStatusOutputFluentImpl<BuildStatusFluent.OutputNested<N>>
    implements BuildStatusFluent.OutputNested<N>,
    Nested<N> {
        private final BuildStatusOutputBuilder builder;

        OutputNestedImpl(BuildStatusOutput item) {
            this.builder = new BuildStatusOutputBuilder(this, item);
        }

        OutputNestedImpl() {
            this.builder = new BuildStatusOutputBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildStatusFluentImpl.this.withOutput(this.builder.build());
        }

        @Override
        public N endOutput() {
            return this.and();
        }
    }

    public class ConfigNestedImpl<N>
    extends ObjectReferenceFluentImpl<BuildStatusFluent.ConfigNested<N>>
    implements BuildStatusFluent.ConfigNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        ConfigNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        ConfigNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildStatusFluentImpl.this.withConfig(this.builder.build());
        }

        @Override
        public N endConfig() {
            return this.and();
        }
    }
}

