/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_2.handlers;

import io.fabric8.kubernetes.api.model.v4_2.rbac.Role;
import io.fabric8.kubernetes.api.model.v4_2.rbac.RoleBuilder;
import io.fabric8.kubernetes.clnt.v4_2.Config;
import io.fabric8.kubernetes.clnt.v4_2.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_2.Watch;
import io.fabric8.kubernetes.clnt.v4_2.Watcher;
import io.fabric8.kubernetes.clnt.v4_2.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_2.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_2.dsl.internal.RoleOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class RoleHandler
implements ResourceHandler<Role, RoleBuilder> {
    @Override
    public String getKind() {
        return Role.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "rbac.authorization.k8s.io/v1";
    }

    @Override
    public Role create(OkHttpClient client, Config config, String namespace, Role item) {
        return (Role)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new Role[0]);
    }

    @Override
    public Role replace(OkHttpClient client, Config config, String namespace, Role item) {
        return (Role)((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Role reload(OkHttpClient client, Config config, String namespace, Role item) {
        return (Role)((Gettable)((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public RoleBuilder edit(Role item) {
        return new RoleBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Role item) {
        return (Boolean)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Role item, Watcher<Role> watcher) {
        return (Watch)((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Role item, String resourceVersion, Watcher<Role> watcher) {
        return (Watch)((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Role waitUntilReady(OkHttpClient client, Config config, String namespace, Role item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Role)((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Role waitUntilCondition(OkHttpClient client, Config config, String namespace, Role item, Predicate<Role> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Role)((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

