/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_2.handlers;

import io.fabric8.kubernetes.api.model.v4_2.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.v4_2.apps.DaemonSetBuilder;
import io.fabric8.kubernetes.clnt.v4_2.Config;
import io.fabric8.kubernetes.clnt.v4_2.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_2.Watch;
import io.fabric8.kubernetes.clnt.v4_2.Watcher;
import io.fabric8.kubernetes.clnt.v4_2.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_2.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_2.dsl.internal.DaemonSetOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class DaemonSetHandler
implements ResourceHandler<DaemonSet, DaemonSetBuilder> {
    @Override
    public String getKind() {
        return DaemonSet.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "apps/v1";
    }

    @Override
    public DaemonSet create(OkHttpClient client, Config config, String namespace, DaemonSet item) {
        return (DaemonSet)new DaemonSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new DaemonSet[0]);
    }

    @Override
    public DaemonSet replace(OkHttpClient client, Config config, String namespace, DaemonSet item) {
        return (DaemonSet)((Resource)new DaemonSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public DaemonSet reload(OkHttpClient client, Config config, String namespace, DaemonSet item) {
        return (DaemonSet)((Gettable)((Resource)new DaemonSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public DaemonSetBuilder edit(DaemonSet item) {
        return new DaemonSetBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DaemonSet item) {
        return (Boolean)new DaemonSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, DaemonSet item, Watcher<DaemonSet> watcher) {
        return (Watch)((Resource)new DaemonSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, DaemonSet item, String resourceVersion, Watcher<DaemonSet> watcher) {
        return (Watch)((Resource)new DaemonSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public DaemonSet waitUntilReady(OkHttpClient client, Config config, String namespace, DaemonSet item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (DaemonSet)((Resource)new DaemonSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public DaemonSet waitUntilCondition(OkHttpClient client, Config config, String namespace, DaemonSet item, Predicate<DaemonSet> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (DaemonSet)((Resource)new DaemonSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

