/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_2.dsl.internal;

import io.fabric8.kubernetes.api.model.v4_2.Container;
import io.fabric8.kubernetes.api.model.v4_2.ContainerBuilder;
import io.fabric8.kubernetes.api.model.v4_2.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.v4_2.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.v4_2.ReplicationController;
import io.fabric8.kubernetes.api.model.v4_2.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.v4_2.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.v4_2.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v4_2.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.clnt.v4_2.Config;
import io.fabric8.kubernetes.clnt.v4_2.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_2.dsl.ImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v4_2.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v4_2.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v4_2.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_2.dsl.internal.ReplicaSetOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_2.dsl.internal.ReplicationControllerRollingUpdater;
import io.fabric8.kubernetes.clnt.v4_2.dsl.internal.RollableScalableResourceOperation;
import io.fabric8.kubernetes.clnt.v4_2.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.clnt.v4_2.dsl.internal.RollingUpdater;
import java.io.InputStream;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class ReplicationControllerOperationsImpl
extends RollableScalableResourceOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, RollableScalableResource<ReplicationController, DoneableReplicationController>>
implements TimeoutImageEditReplacePatchable<ReplicationController, ReplicationController, DoneableReplicationController> {
    public ReplicationControllerOperationsImpl(OkHttpClient client, Config config) {
        this(new RollingOperationContext().withOkhttpClient(client).withConfig(config));
    }

    public ReplicationControllerOperationsImpl(RollingOperationContext context) {
        super(context.withPlural("replicationcontrollers"));
        this.type = ReplicationController.class;
        this.listType = ReplicationControllerList.class;
        this.doneableType = DoneableReplicationController.class;
    }

    public ReplicationControllerOperationsImpl newInstance(OperationContext context) {
        return new ReplicationControllerOperationsImpl((RollingOperationContext)context);
    }

    @Override
    public RollableScalableResource<ReplicationController, DoneableReplicationController> load(InputStream is) {
        try {
            ReplicationController item = ReplicationControllerOperationsImpl.unmarshal(is, ReplicationController.class);
            return new ReplicationControllerOperationsImpl((RollingOperationContext)this.context.withItem(item));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    ReplicationController withReplicas(int count) {
        return ((DoneableReplicationController)((ReplicationControllerFluent.SpecNested)((DoneableReplicationController)this.cascading(false).edit()).editSpec().withReplicas(count)).endSpec()).done();
    }

    @Override
    RollingUpdater<ReplicationController, ReplicationControllerList, DoneableReplicationController> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new ReplicationControllerRollingUpdater(this.client, this.config, this.namespace, rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    int getCurrentReplicas(ReplicationController current) {
        return current.getStatus().getReplicas();
    }

    @Override
    int getDesiredReplicas(ReplicationController item) {
        return item.getSpec().getReplicas();
    }

    @Override
    long getObservedGeneration(ReplicationController current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    @Override
    public ReplicationController updateImage(String image) {
        ReplicationController oldRC = (ReplicationController)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing replication controller doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() == 0) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container updatedContainer = ((ContainerBuilder)new ContainerBuilder(oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next()).withImage(image)).build();
        ReplicationControllerBuilder newRCBuilder = new ReplicationControllerBuilder(oldRC);
        ((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)newRCBuilder.editMetadata().withResourceVersion(null)).endMetadata()).editSpec().editTemplate().editSpec().withContainers(Collections.singletonList(updatedContainer))).endSpec()).endTemplate()).endSpec();
        return new ReplicationControllerRollingUpdater(this.client, this.config, this.namespace).rollUpdate(oldRC, newRCBuilder.build());
    }

    @Override
    public TimeoutImageEditReplacePatchable rolling() {
        return new ReplicaSetOperationsImpl(((RollingOperationContext)this.context).withRolling(true));
    }

    @Override
    public ImageEditReplacePatchable<ReplicationController, ReplicationController, DoneableReplicationController> withTimeout(long timeout, TimeUnit unit) {
        return new ReplicationControllerOperationsImpl(((RollingOperationContext)this.context).withRollingTimeout(unit.toMillis(timeout)).withRollingTimeUnit(TimeUnit.MILLISECONDS));
    }

    @Override
    public ImageEditReplacePatchable<ReplicationController, ReplicationController, DoneableReplicationController> withTimeoutInMillis(long timeoutInMillis) {
        return new ReplicationControllerOperationsImpl(((RollingOperationContext)this.context).withRollingTimeout(timeoutInMillis));
    }
}

