/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2.policy;

import io.fabric8.kubernetes.api.builder.v4_2.BaseFluent;
import io.fabric8.kubernetes.api.model.v4_2.policy.PodDisruptionBudgetStatus;
import io.fabric8.kubernetes.api.model.v4_2.policy.PodDisruptionBudgetStatusFluent;
import java.util.LinkedHashMap;
import java.util.Map;

public class PodDisruptionBudgetStatusFluentImpl<A extends PodDisruptionBudgetStatusFluent<A>>
extends BaseFluent<A>
implements PodDisruptionBudgetStatusFluent<A> {
    private Integer currentHealthy;
    private Integer desiredHealthy;
    private Map<String, String> disruptedPods;
    private Integer disruptionsAllowed;
    private Integer expectedPods;
    private Long observedGeneration;

    public PodDisruptionBudgetStatusFluentImpl() {
    }

    public PodDisruptionBudgetStatusFluentImpl(PodDisruptionBudgetStatus instance) {
        this.withCurrentHealthy(instance.getCurrentHealthy());
        this.withDesiredHealthy(instance.getDesiredHealthy());
        this.withDisruptedPods(instance.getDisruptedPods());
        this.withDisruptionsAllowed(instance.getDisruptionsAllowed());
        this.withExpectedPods(instance.getExpectedPods());
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    @Override
    public Integer getCurrentHealthy() {
        return this.currentHealthy;
    }

    @Override
    public A withCurrentHealthy(Integer currentHealthy) {
        this.currentHealthy = currentHealthy;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentHealthy() {
        return this.currentHealthy != null;
    }

    @Override
    public Integer getDesiredHealthy() {
        return this.desiredHealthy;
    }

    @Override
    public A withDesiredHealthy(Integer desiredHealthy) {
        this.desiredHealthy = desiredHealthy;
        return (A)this;
    }

    @Override
    public Boolean hasDesiredHealthy() {
        return this.desiredHealthy != null;
    }

    @Override
    public A addToDisruptedPods(String key, String value) {
        if (this.disruptedPods == null && key != null && value != null) {
            this.disruptedPods = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.disruptedPods.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToDisruptedPods(Map<String, String> map) {
        if (this.disruptedPods == null && map != null) {
            this.disruptedPods = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.disruptedPods.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromDisruptedPods(String key) {
        if (this.disruptedPods == null) {
            return (A)this;
        }
        if (key != null && this.disruptedPods != null) {
            this.disruptedPods.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromDisruptedPods(Map<String, String> map) {
        if (this.disruptedPods == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.disruptedPods == null) continue;
                this.disruptedPods.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getDisruptedPods() {
        return this.disruptedPods;
    }

    @Override
    public A withDisruptedPods(Map<String, String> disruptedPods) {
        this.disruptedPods = disruptedPods == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(disruptedPods);
        return (A)this;
    }

    @Override
    public Boolean hasDisruptedPods() {
        return this.disruptedPods != null;
    }

    @Override
    public Integer getDisruptionsAllowed() {
        return this.disruptionsAllowed;
    }

    @Override
    public A withDisruptionsAllowed(Integer disruptionsAllowed) {
        this.disruptionsAllowed = disruptionsAllowed;
        return (A)this;
    }

    @Override
    public Boolean hasDisruptionsAllowed() {
        return this.disruptionsAllowed != null;
    }

    @Override
    public Integer getExpectedPods() {
        return this.expectedPods;
    }

    @Override
    public A withExpectedPods(Integer expectedPods) {
        this.expectedPods = expectedPods;
        return (A)this;
    }

    @Override
    public Boolean hasExpectedPods() {
        return this.expectedPods != null;
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodDisruptionBudgetStatusFluentImpl that = (PodDisruptionBudgetStatusFluentImpl)o;
        if (this.currentHealthy != null ? !this.currentHealthy.equals(that.currentHealthy) : that.currentHealthy != null) {
            return false;
        }
        if (this.desiredHealthy != null ? !this.desiredHealthy.equals(that.desiredHealthy) : that.desiredHealthy != null) {
            return false;
        }
        if (this.disruptedPods != null ? !this.disruptedPods.equals(that.disruptedPods) : that.disruptedPods != null) {
            return false;
        }
        if (this.disruptionsAllowed != null ? !this.disruptionsAllowed.equals(that.disruptionsAllowed) : that.disruptionsAllowed != null) {
            return false;
        }
        if (this.expectedPods != null ? !this.expectedPods.equals(that.expectedPods) : that.expectedPods != null) {
            return false;
        }
        return !(this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null);
    }
}

