/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2.authorization;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_2.authorization.ResourceAttributes;
import io.fabric8.kubernetes.api.model.v4_2.authorization.ResourceAttributesFluent;
import io.fabric8.kubernetes.api.model.v4_2.authorization.ResourceAttributesFluentImpl;
import javax.validation.Validator;

public class ResourceAttributesBuilder
extends ResourceAttributesFluentImpl<ResourceAttributesBuilder>
implements VisitableBuilder<ResourceAttributes, ResourceAttributesBuilder> {
    ResourceAttributesFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ResourceAttributesBuilder() {
        this(true);
    }

    public ResourceAttributesBuilder(Boolean validationEnabled) {
        this(new ResourceAttributes(), validationEnabled);
    }

    public ResourceAttributesBuilder(ResourceAttributesFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ResourceAttributesBuilder(ResourceAttributesFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceAttributes(), validationEnabled);
    }

    public ResourceAttributesBuilder(ResourceAttributesFluent<?> fluent, ResourceAttributes instance) {
        this(fluent, instance, true);
    }

    public ResourceAttributesBuilder(ResourceAttributesFluent<?> fluent, ResourceAttributes instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withGroup(instance.getGroup());
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withResource(instance.getResource());
        fluent.withSubresource(instance.getSubresource());
        fluent.withVerb(instance.getVerb());
        fluent.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    public ResourceAttributesBuilder(ResourceAttributes instance) {
        this(instance, (Boolean)true);
    }

    public ResourceAttributesBuilder(ResourceAttributes instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withGroup(instance.getGroup());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withResource(instance.getResource());
        this.withSubresource(instance.getSubresource());
        this.withVerb(instance.getVerb());
        this.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    public ResourceAttributesBuilder(Validator validator) {
        this(new ResourceAttributes(), (Boolean)true);
    }

    public ResourceAttributesBuilder(ResourceAttributesFluent<?> fluent, ResourceAttributes instance, Validator validator) {
        this.fluent = fluent;
        fluent.withGroup(instance.getGroup());
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        fluent.withResource(instance.getResource());
        fluent.withSubresource(instance.getSubresource());
        fluent.withVerb(instance.getVerb());
        fluent.withVersion(instance.getVersion());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ResourceAttributesBuilder(ResourceAttributes instance, Validator validator) {
        this.fluent = this;
        this.withGroup(instance.getGroup());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withResource(instance.getResource());
        this.withSubresource(instance.getSubresource());
        this.withVerb(instance.getVerb());
        this.withVersion(instance.getVersion());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ResourceAttributes build() {
        ResourceAttributes buildable = new ResourceAttributes(this.fluent.getGroup(), this.fluent.getName(), this.fluent.getNamespace(), this.fluent.getResource(), this.fluent.getSubresource(), this.fluent.getVerb(), this.fluent.getVersion());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceAttributesBuilder that = (ResourceAttributesBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

