/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2.apiextensions;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_2.apiextensions.JSON;
import io.fabric8.kubernetes.api.model.v4_2.apiextensions.JSONFluent;
import io.fabric8.kubernetes.api.model.v4_2.apiextensions.JSONFluentImpl;
import javax.validation.Validator;

public class JSONBuilder
extends JSONFluentImpl<JSONBuilder>
implements VisitableBuilder<JSON, JSONBuilder> {
    JSONFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public JSONBuilder() {
        this(true);
    }

    public JSONBuilder(Boolean validationEnabled) {
        this(new JSON(), validationEnabled);
    }

    public JSONBuilder(JSONFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public JSONBuilder(JSONFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new JSON(), validationEnabled);
    }

    public JSONBuilder(JSONFluent<?> fluent, JSON instance) {
        this(fluent, instance, true);
    }

    public JSONBuilder(JSONFluent<?> fluent, JSON instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withRaw(instance.getRaw());
        this.validationEnabled = validationEnabled;
    }

    public JSONBuilder(JSON instance) {
        this(instance, (Boolean)true);
    }

    public JSONBuilder(JSON instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withRaw(instance.getRaw());
        this.validationEnabled = validationEnabled;
    }

    public JSONBuilder(Validator validator) {
        this(new JSON(), (Boolean)true);
    }

    public JSONBuilder(JSONFluent<?> fluent, JSON instance, Validator validator) {
        this.fluent = fluent;
        fluent.withRaw(instance.getRaw());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public JSONBuilder(JSON instance, Validator validator) {
        this.fluent = this;
        this.withRaw(instance.getRaw());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public JSON build() {
        JSON buildable = new JSON(this.fluent.getRaw());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JSONBuilder that = (JSONBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

