/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2.apiextensions;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_2.apiextensions.CustomResourceSubresources;
import io.fabric8.kubernetes.api.model.v4_2.apiextensions.CustomResourceSubresourcesFluent;
import io.fabric8.kubernetes.api.model.v4_2.apiextensions.CustomResourceSubresourcesFluentImpl;
import javax.validation.Validator;

public class CustomResourceSubresourcesBuilder
extends CustomResourceSubresourcesFluentImpl<CustomResourceSubresourcesBuilder>
implements VisitableBuilder<CustomResourceSubresources, CustomResourceSubresourcesBuilder> {
    CustomResourceSubresourcesFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public CustomResourceSubresourcesBuilder() {
        this(true);
    }

    public CustomResourceSubresourcesBuilder(Boolean validationEnabled) {
        this(new CustomResourceSubresources(), validationEnabled);
    }

    public CustomResourceSubresourcesBuilder(CustomResourceSubresourcesFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CustomResourceSubresourcesBuilder(CustomResourceSubresourcesFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CustomResourceSubresources(), validationEnabled);
    }

    public CustomResourceSubresourcesBuilder(CustomResourceSubresourcesFluent<?> fluent, CustomResourceSubresources instance) {
        this(fluent, instance, true);
    }

    public CustomResourceSubresourcesBuilder(CustomResourceSubresourcesFluent<?> fluent, CustomResourceSubresources instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withScale(instance.getScale());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public CustomResourceSubresourcesBuilder(CustomResourceSubresources instance) {
        this(instance, (Boolean)true);
    }

    public CustomResourceSubresourcesBuilder(CustomResourceSubresources instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withScale(instance.getScale());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public CustomResourceSubresourcesBuilder(Validator validator) {
        this(new CustomResourceSubresources(), (Boolean)true);
    }

    public CustomResourceSubresourcesBuilder(CustomResourceSubresourcesFluent<?> fluent, CustomResourceSubresources instance, Validator validator) {
        this.fluent = fluent;
        fluent.withScale(instance.getScale());
        fluent.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public CustomResourceSubresourcesBuilder(CustomResourceSubresources instance, Validator validator) {
        this.fluent = this;
        this.withScale(instance.getScale());
        this.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public CustomResourceSubresources build() {
        CustomResourceSubresources buildable = new CustomResourceSubresources(this.fluent.getScale(), this.fluent.getStatus());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomResourceSubresourcesBuilder that = (CustomResourceSubresourcesBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

