/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_2.NodeSelector;
import io.fabric8.kubernetes.api.model.v4_2.NodeSelectorFluent;
import io.fabric8.kubernetes.api.model.v4_2.NodeSelectorFluentImpl;
import javax.validation.Validator;

public class NodeSelectorBuilder
extends NodeSelectorFluentImpl<NodeSelectorBuilder>
implements VisitableBuilder<NodeSelector, NodeSelectorBuilder> {
    NodeSelectorFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NodeSelectorBuilder() {
        this(true);
    }

    public NodeSelectorBuilder(Boolean validationEnabled) {
        this(new NodeSelector(), validationEnabled);
    }

    public NodeSelectorBuilder(NodeSelectorFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NodeSelectorBuilder(NodeSelectorFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NodeSelector(), validationEnabled);
    }

    public NodeSelectorBuilder(NodeSelectorFluent<?> fluent, NodeSelector instance) {
        this(fluent, instance, true);
    }

    public NodeSelectorBuilder(NodeSelectorFluent<?> fluent, NodeSelector instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNodeSelectorTerms(instance.getNodeSelectorTerms());
        this.validationEnabled = validationEnabled;
    }

    public NodeSelectorBuilder(NodeSelector instance) {
        this(instance, (Boolean)true);
    }

    public NodeSelectorBuilder(NodeSelector instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNodeSelectorTerms(instance.getNodeSelectorTerms());
        this.validationEnabled = validationEnabled;
    }

    public NodeSelectorBuilder(Validator validator) {
        this(new NodeSelector(), (Boolean)true);
    }

    public NodeSelectorBuilder(NodeSelectorFluent<?> fluent, NodeSelector instance, Validator validator) {
        this.fluent = fluent;
        fluent.withNodeSelectorTerms(instance.getNodeSelectorTerms());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public NodeSelectorBuilder(NodeSelector instance, Validator validator) {
        this.fluent = this;
        this.withNodeSelectorTerms(instance.getNodeSelectorTerms());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public NodeSelector build() {
        NodeSelector buildable = new NodeSelector(this.fluent.getNodeSelectorTerms());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeSelectorBuilder that = (NodeSelectorBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

