/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_2.NodeAddress;
import io.fabric8.kubernetes.api.model.v4_2.NodeAddressFluent;
import io.fabric8.kubernetes.api.model.v4_2.NodeAddressFluentImpl;
import javax.validation.Validator;

public class NodeAddressBuilder
extends NodeAddressFluentImpl<NodeAddressBuilder>
implements VisitableBuilder<NodeAddress, NodeAddressBuilder> {
    NodeAddressFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NodeAddressBuilder() {
        this(true);
    }

    public NodeAddressBuilder(Boolean validationEnabled) {
        this(new NodeAddress(), validationEnabled);
    }

    public NodeAddressBuilder(NodeAddressFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NodeAddressBuilder(NodeAddressFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NodeAddress(), validationEnabled);
    }

    public NodeAddressBuilder(NodeAddressFluent<?> fluent, NodeAddress instance) {
        this(fluent, instance, true);
    }

    public NodeAddressBuilder(NodeAddressFluent<?> fluent, NodeAddress instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddress(instance.getAddress());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public NodeAddressBuilder(NodeAddress instance) {
        this(instance, (Boolean)true);
    }

    public NodeAddressBuilder(NodeAddress instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddress(instance.getAddress());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public NodeAddressBuilder(Validator validator) {
        this(new NodeAddress(), (Boolean)true);
    }

    public NodeAddressBuilder(NodeAddressFluent<?> fluent, NodeAddress instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAddress(instance.getAddress());
        fluent.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public NodeAddressBuilder(NodeAddress instance, Validator validator) {
        this.fluent = this;
        this.withAddress(instance.getAddress());
        this.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public NodeAddress build() {
        NodeAddress buildable = new NodeAddress(this.fluent.getAddress(), this.fluent.getType());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeAddressBuilder that = (NodeAddressBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

