/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_2.NamedExtension;
import io.fabric8.kubernetes.api.model.v4_2.NamedExtensionFluent;
import io.fabric8.kubernetes.api.model.v4_2.NamedExtensionFluentImpl;
import javax.validation.Validator;

public class NamedExtensionBuilder
extends NamedExtensionFluentImpl<NamedExtensionBuilder>
implements VisitableBuilder<NamedExtension, NamedExtensionBuilder> {
    NamedExtensionFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NamedExtensionBuilder() {
        this(true);
    }

    public NamedExtensionBuilder(Boolean validationEnabled) {
        this(new NamedExtension(), validationEnabled);
    }

    public NamedExtensionBuilder(NamedExtensionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NamedExtensionBuilder(NamedExtensionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NamedExtension(), validationEnabled);
    }

    public NamedExtensionBuilder(NamedExtensionFluent<?> fluent, NamedExtension instance) {
        this(fluent, instance, true);
    }

    public NamedExtensionBuilder(NamedExtensionFluent<?> fluent, NamedExtension instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withExtension(instance.getExtension());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public NamedExtensionBuilder(NamedExtension instance) {
        this(instance, (Boolean)true);
    }

    public NamedExtensionBuilder(NamedExtension instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withExtension(instance.getExtension());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public NamedExtensionBuilder(Validator validator) {
        this(new NamedExtension(), (Boolean)true);
    }

    public NamedExtensionBuilder(NamedExtensionFluent<?> fluent, NamedExtension instance, Validator validator) {
        this.fluent = fluent;
        fluent.withExtension(instance.getExtension());
        fluent.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public NamedExtensionBuilder(NamedExtension instance, Validator validator) {
        this.fluent = this;
        this.withExtension(instance.getExtension());
        this.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public NamedExtension build() {
        NamedExtension buildable = new NamedExtension(this.fluent.getExtension(), this.fluent.getName());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedExtensionBuilder that = (NamedExtensionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

