/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_2.Nested;
import io.fabric8.kubernetes.api.builder.v4_2.Predicate;
import io.fabric8.kubernetes.api.model.v4_2.HorizontalPodAutoscalerCondition;
import io.fabric8.kubernetes.api.model.v4_2.HorizontalPodAutoscalerConditionBuilder;
import io.fabric8.kubernetes.api.model.v4_2.HorizontalPodAutoscalerConditionFluentImpl;
import io.fabric8.kubernetes.api.model.v4_2.HorizontalPodAutoscalerStatus;
import io.fabric8.kubernetes.api.model.v4_2.HorizontalPodAutoscalerStatusFluent;
import io.fabric8.kubernetes.api.model.v4_2.MetricStatus;
import io.fabric8.kubernetes.api.model.v4_2.MetricStatusBuilder;
import io.fabric8.kubernetes.api.model.v4_2.MetricStatusFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HorizontalPodAutoscalerStatusFluentImpl<A extends HorizontalPodAutoscalerStatusFluent<A>>
extends BaseFluent<A>
implements HorizontalPodAutoscalerStatusFluent<A> {
    private List<HorizontalPodAutoscalerConditionBuilder> conditions;
    private List<MetricStatusBuilder> currentMetrics;
    private Integer currentReplicas;
    private Integer desiredReplicas;
    private String lastScaleTime;
    private Long observedGeneration;

    public HorizontalPodAutoscalerStatusFluentImpl() {
    }

    public HorizontalPodAutoscalerStatusFluentImpl(HorizontalPodAutoscalerStatus instance) {
        this.withConditions(instance.getConditions());
        this.withCurrentMetrics(instance.getCurrentMetrics());
        this.withCurrentReplicas(instance.getCurrentReplicas());
        this.withDesiredReplicas(instance.getDesiredReplicas());
        this.withLastScaleTime(instance.getLastScaleTime());
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    @Override
    public A addToConditions(int index, HorizontalPodAutoscalerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<HorizontalPodAutoscalerConditionBuilder>();
        }
        HorizontalPodAutoscalerConditionBuilder builder = new HorizontalPodAutoscalerConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, HorizontalPodAutoscalerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<HorizontalPodAutoscalerConditionBuilder>();
        }
        HorizontalPodAutoscalerConditionBuilder builder = new HorizontalPodAutoscalerConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(HorizontalPodAutoscalerCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<HorizontalPodAutoscalerConditionBuilder>();
        }
        for (HorizontalPodAutoscalerCondition item : items) {
            HorizontalPodAutoscalerConditionBuilder builder = new HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<HorizontalPodAutoscalerCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<HorizontalPodAutoscalerConditionBuilder>();
        }
        for (HorizontalPodAutoscalerCondition item : items) {
            HorizontalPodAutoscalerConditionBuilder builder = new HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(HorizontalPodAutoscalerCondition ... items) {
        for (HorizontalPodAutoscalerCondition item : items) {
            HorizontalPodAutoscalerConditionBuilder builder = new HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<HorizontalPodAutoscalerCondition> items) {
        for (HorizontalPodAutoscalerCondition item : items) {
            HorizontalPodAutoscalerConditionBuilder builder = new HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HorizontalPodAutoscalerCondition> getConditions() {
        return HorizontalPodAutoscalerStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<HorizontalPodAutoscalerCondition> buildConditions() {
        return HorizontalPodAutoscalerStatusFluentImpl.build(this.conditions);
    }

    @Override
    public HorizontalPodAutoscalerCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public HorizontalPodAutoscalerCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public HorizontalPodAutoscalerCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public HorizontalPodAutoscalerCondition buildMatchingCondition(Predicate<HorizontalPodAutoscalerConditionBuilder> predicate) {
        for (HorizontalPodAutoscalerConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<HorizontalPodAutoscalerConditionBuilder> predicate) {
        for (HorizontalPodAutoscalerConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<HorizontalPodAutoscalerCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<HorizontalPodAutoscalerConditionBuilder>();
            for (HorizontalPodAutoscalerCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = new ArrayList<HorizontalPodAutoscalerConditionBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withConditions(HorizontalPodAutoscalerCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (HorizontalPodAutoscalerCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new HorizontalPodAutoscalerCondition(lastTransitionTime, message, reason, status, type));
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> addNewConditionLike(HorizontalPodAutoscalerCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> setNewConditionLike(int index, HorizontalPodAutoscalerCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<HorizontalPodAutoscalerConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply(this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public A addToCurrentMetrics(int index, MetricStatus item) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList<MetricStatusBuilder>();
        }
        MetricStatusBuilder builder = new MetricStatusBuilder(item);
        this._visitables.get("currentMetrics").add(index >= 0 ? index : this._visitables.get("currentMetrics").size(), builder);
        this.currentMetrics.add(index >= 0 ? index : this.currentMetrics.size(), builder);
        return (A)this;
    }

    @Override
    public A setToCurrentMetrics(int index, MetricStatus item) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList<MetricStatusBuilder>();
        }
        MetricStatusBuilder builder = new MetricStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get("currentMetrics").size()) {
            this._visitables.get("currentMetrics").add(builder);
        } else {
            this._visitables.get("currentMetrics").set(index, builder);
        }
        if (index < 0 || index >= this.currentMetrics.size()) {
            this.currentMetrics.add(builder);
        } else {
            this.currentMetrics.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToCurrentMetrics(MetricStatus ... items) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList<MetricStatusBuilder>();
        }
        for (MetricStatus item : items) {
            MetricStatusBuilder builder = new MetricStatusBuilder(item);
            this._visitables.get("currentMetrics").add(builder);
            this.currentMetrics.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToCurrentMetrics(Collection<MetricStatus> items) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList<MetricStatusBuilder>();
        }
        for (MetricStatus item : items) {
            MetricStatusBuilder builder = new MetricStatusBuilder(item);
            this._visitables.get("currentMetrics").add(builder);
            this.currentMetrics.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromCurrentMetrics(MetricStatus ... items) {
        for (MetricStatus item : items) {
            MetricStatusBuilder builder = new MetricStatusBuilder(item);
            this._visitables.get("currentMetrics").remove(builder);
            if (this.currentMetrics == null) continue;
            this.currentMetrics.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCurrentMetrics(Collection<MetricStatus> items) {
        for (MetricStatus item : items) {
            MetricStatusBuilder builder = new MetricStatusBuilder(item);
            this._visitables.get("currentMetrics").remove(builder);
            if (this.currentMetrics == null) continue;
            this.currentMetrics.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<MetricStatus> getCurrentMetrics() {
        return HorizontalPodAutoscalerStatusFluentImpl.build(this.currentMetrics);
    }

    @Override
    public List<MetricStatus> buildCurrentMetrics() {
        return HorizontalPodAutoscalerStatusFluentImpl.build(this.currentMetrics);
    }

    @Override
    public MetricStatus buildCurrentMetric(int index) {
        return this.currentMetrics.get(index).build();
    }

    @Override
    public MetricStatus buildFirstCurrentMetric() {
        return this.currentMetrics.get(0).build();
    }

    @Override
    public MetricStatus buildLastCurrentMetric() {
        return this.currentMetrics.get(this.currentMetrics.size() - 1).build();
    }

    @Override
    public MetricStatus buildMatchingCurrentMetric(Predicate<MetricStatusBuilder> predicate) {
        for (MetricStatusBuilder item : this.currentMetrics) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCurrentMetric(Predicate<MetricStatusBuilder> predicate) {
        for (MetricStatusBuilder item : this.currentMetrics) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCurrentMetrics(List<MetricStatus> currentMetrics) {
        if (this.currentMetrics != null) {
            this._visitables.get("currentMetrics").removeAll(this.currentMetrics);
        }
        if (currentMetrics != null) {
            this.currentMetrics = new ArrayList<MetricStatusBuilder>();
            for (MetricStatus item : currentMetrics) {
                this.addToCurrentMetrics(item);
            }
        } else {
            this.currentMetrics = new ArrayList<MetricStatusBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withCurrentMetrics(MetricStatus ... currentMetrics) {
        if (this.currentMetrics != null) {
            this.currentMetrics.clear();
        }
        if (currentMetrics != null) {
            for (MetricStatus item : currentMetrics) {
                this.addToCurrentMetrics(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCurrentMetrics() {
        return this.currentMetrics != null && !this.currentMetrics.isEmpty();
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> addNewCurrentMetric() {
        return new CurrentMetricsNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> addNewCurrentMetricLike(MetricStatus item) {
        return new CurrentMetricsNestedImpl(-1, item);
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> setNewCurrentMetricLike(int index, MetricStatus item) {
        return new CurrentMetricsNestedImpl(index, item);
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editCurrentMetric(int index) {
        if (this.currentMetrics.size() <= index) {
            throw new RuntimeException("Can't edit currentMetrics. Index exceeds size.");
        }
        return this.setNewCurrentMetricLike(index, this.buildCurrentMetric(index));
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editFirstCurrentMetric() {
        if (this.currentMetrics.size() == 0) {
            throw new RuntimeException("Can't edit first currentMetrics. The list is empty.");
        }
        return this.setNewCurrentMetricLike(0, this.buildCurrentMetric(0));
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editLastCurrentMetric() {
        int index = this.currentMetrics.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last currentMetrics. The list is empty.");
        }
        return this.setNewCurrentMetricLike(index, this.buildCurrentMetric(index));
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editMatchingCurrentMetric(Predicate<MetricStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.currentMetrics.size(); ++i) {
            if (!predicate.apply(this.currentMetrics.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching currentMetrics. No match found.");
        }
        return this.setNewCurrentMetricLike(index, this.buildCurrentMetric(index));
    }

    @Override
    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    @Override
    public A withCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentReplicas() {
        return this.currentReplicas != null;
    }

    @Override
    public Integer getDesiredReplicas() {
        return this.desiredReplicas;
    }

    @Override
    public A withDesiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasDesiredReplicas() {
        return this.desiredReplicas != null;
    }

    @Override
    public String getLastScaleTime() {
        return this.lastScaleTime;
    }

    @Override
    public A withLastScaleTime(String lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
        return (A)this;
    }

    @Override
    public Boolean hasLastScaleTime() {
        return this.lastScaleTime != null;
    }

    @Override
    public A withNewLastScaleTime(String arg1) {
        return this.withLastScaleTime(new String(arg1));
    }

    @Override
    public A withNewLastScaleTime(StringBuilder arg1) {
        return this.withLastScaleTime(new String(arg1));
    }

    @Override
    public A withNewLastScaleTime(StringBuffer arg1) {
        return this.withLastScaleTime(new String(arg1));
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HorizontalPodAutoscalerStatusFluentImpl that = (HorizontalPodAutoscalerStatusFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.currentMetrics != null ? !this.currentMetrics.equals(that.currentMetrics) : that.currentMetrics != null) {
            return false;
        }
        if (this.currentReplicas != null ? !this.currentReplicas.equals(that.currentReplicas) : that.currentReplicas != null) {
            return false;
        }
        if (this.desiredReplicas != null ? !this.desiredReplicas.equals(that.desiredReplicas) : that.desiredReplicas != null) {
            return false;
        }
        if (this.lastScaleTime != null ? !this.lastScaleTime.equals(that.lastScaleTime) : that.lastScaleTime != null) {
            return false;
        }
        return !(this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null);
    }

    public class CurrentMetricsNestedImpl<N>
    extends MetricStatusFluentImpl<HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<N>>
    implements HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<N>,
    Nested<N> {
        private final MetricStatusBuilder builder;
        private final int index;

        CurrentMetricsNestedImpl(int index, MetricStatus item) {
            this.index = index;
            this.builder = new MetricStatusBuilder(this, item);
        }

        CurrentMetricsNestedImpl() {
            this.index = -1;
            this.builder = new MetricStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerStatusFluentImpl.this.setToCurrentMetrics(this.index, this.builder.build());
        }

        @Override
        public N endCurrentMetric() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends HorizontalPodAutoscalerConditionFluentImpl<HorizontalPodAutoscalerStatusFluent.ConditionsNested<N>>
    implements HorizontalPodAutoscalerStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final HorizontalPodAutoscalerConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, HorizontalPodAutoscalerCondition item) {
            this.index = index;
            this.builder = new HorizontalPodAutoscalerConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new HorizontalPodAutoscalerConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

