/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_2.GroupVersionKind;
import io.fabric8.kubernetes.api.model.v4_2.GroupVersionKindFluent;
import io.fabric8.kubernetes.api.model.v4_2.GroupVersionKindFluentImpl;
import javax.validation.Validator;

public class GroupVersionKindBuilder
extends GroupVersionKindFluentImpl<GroupVersionKindBuilder>
implements VisitableBuilder<GroupVersionKind, GroupVersionKindBuilder> {
    GroupVersionKindFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public GroupVersionKindBuilder() {
        this(true);
    }

    public GroupVersionKindBuilder(Boolean validationEnabled) {
        this(new GroupVersionKind(), validationEnabled);
    }

    public GroupVersionKindBuilder(GroupVersionKindFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public GroupVersionKindBuilder(GroupVersionKindFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new GroupVersionKind(), validationEnabled);
    }

    public GroupVersionKindBuilder(GroupVersionKindFluent<?> fluent, GroupVersionKind instance) {
        this(fluent, instance, true);
    }

    public GroupVersionKindBuilder(GroupVersionKindFluent<?> fluent, GroupVersionKind instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withGroup(instance.getGroup());
        fluent.withKind(instance.getKind());
        fluent.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    public GroupVersionKindBuilder(GroupVersionKind instance) {
        this(instance, (Boolean)true);
    }

    public GroupVersionKindBuilder(GroupVersionKind instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withGroup(instance.getGroup());
        this.withKind(instance.getKind());
        this.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    public GroupVersionKindBuilder(Validator validator) {
        this(new GroupVersionKind(), (Boolean)true);
    }

    public GroupVersionKindBuilder(GroupVersionKindFluent<?> fluent, GroupVersionKind instance, Validator validator) {
        this.fluent = fluent;
        fluent.withGroup(instance.getGroup());
        fluent.withKind(instance.getKind());
        fluent.withVersion(instance.getVersion());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public GroupVersionKindBuilder(GroupVersionKind instance, Validator validator) {
        this.fluent = this;
        this.withGroup(instance.getGroup());
        this.withKind(instance.getKind());
        this.withVersion(instance.getVersion());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public GroupVersionKind build() {
        GroupVersionKind buildable = new GroupVersionKind(this.fluent.getGroup(), this.fluent.getKind(), this.fluent.getVersion());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupVersionKindBuilder that = (GroupVersionKindBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

