/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_2.Nested;
import io.fabric8.kubernetes.api.model.v4_2.FlexPersistentVolumeSource;
import io.fabric8.kubernetes.api.model.v4_2.FlexPersistentVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.v4_2.SecretReference;
import io.fabric8.kubernetes.api.model.v4_2.SecretReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_2.SecretReferenceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;

public class FlexPersistentVolumeSourceFluentImpl<A extends FlexPersistentVolumeSourceFluent<A>>
extends BaseFluent<A>
implements FlexPersistentVolumeSourceFluent<A> {
    private String driver;
    private String fsType;
    private Map<String, String> options;
    private Boolean readOnly;
    private SecretReferenceBuilder secretRef;

    public FlexPersistentVolumeSourceFluentImpl() {
    }

    public FlexPersistentVolumeSourceFluentImpl(FlexPersistentVolumeSource instance) {
        this.withDriver(instance.getDriver());
        this.withFsType(instance.getFsType());
        this.withOptions(instance.getOptions());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    @Override
    public A withDriver(String driver) {
        this.driver = driver;
        return (A)this;
    }

    @Override
    public Boolean hasDriver() {
        return this.driver != null;
    }

    @Override
    public A withNewDriver(String arg1) {
        return this.withDriver(new String(arg1));
    }

    @Override
    public A withNewDriver(StringBuilder arg1) {
        return this.withDriver(new String(arg1));
    }

    @Override
    public A withNewDriver(StringBuffer arg1) {
        return this.withDriver(new String(arg1));
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public A withNewFsType(String arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    public A withNewFsType(StringBuilder arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    public A withNewFsType(StringBuffer arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    public A addToOptions(String key, String value) {
        if (this.options == null && key != null && value != null) {
            this.options = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.options.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToOptions(Map<String, String> map) {
        if (this.options == null && map != null) {
            this.options = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.options.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromOptions(String key) {
        if (this.options == null) {
            return (A)this;
        }
        if (key != null && this.options != null) {
            this.options.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromOptions(Map<String, String> map) {
        if (this.options == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.options == null) continue;
                this.options.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    public A withOptions(Map<String, String> options) {
        this.options = options == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(options);
        return (A)this;
    }

    @Override
    public Boolean hasOptions() {
        return this.options != null;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    public A withNewReadOnly(String arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    public A withNewReadOnly(boolean arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public SecretReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public SecretReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(SecretReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new SecretReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public A withNewSecretRef(String name, String namespace) {
        return this.withSecretRef(new SecretReference(name, namespace));
    }

    @Override
    public FlexPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public FlexPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(SecretReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public FlexPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public FlexPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new SecretReferenceBuilder().build());
    }

    @Override
    public FlexPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(SecretReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FlexPersistentVolumeSourceFluentImpl that = (FlexPersistentVolumeSourceFluentImpl)o;
        if (this.driver != null ? !this.driver.equals(that.driver) : that.driver != null) {
            return false;
        }
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.options != null ? !this.options.equals(that.options) : that.options != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        return !(this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null);
    }

    public class SecretRefNestedImpl<N>
    extends SecretReferenceFluentImpl<FlexPersistentVolumeSourceFluent.SecretRefNested<N>>
    implements FlexPersistentVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        private final SecretReferenceBuilder builder;

        SecretRefNestedImpl(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new SecretReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)FlexPersistentVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

