/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_2.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.v4_2.ContainerStateTerminatedFluent;
import io.fabric8.kubernetes.api.model.v4_2.ContainerStateTerminatedFluentImpl;
import javax.validation.Validator;

public class ContainerStateTerminatedBuilder
extends ContainerStateTerminatedFluentImpl<ContainerStateTerminatedBuilder>
implements VisitableBuilder<ContainerStateTerminated, ContainerStateTerminatedBuilder> {
    ContainerStateTerminatedFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ContainerStateTerminatedBuilder() {
        this(true);
    }

    public ContainerStateTerminatedBuilder(Boolean validationEnabled) {
        this(new ContainerStateTerminated(), validationEnabled);
    }

    public ContainerStateTerminatedBuilder(ContainerStateTerminatedFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ContainerStateTerminatedBuilder(ContainerStateTerminatedFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerStateTerminated(), validationEnabled);
    }

    public ContainerStateTerminatedBuilder(ContainerStateTerminatedFluent<?> fluent, ContainerStateTerminated instance) {
        this(fluent, instance, true);
    }

    public ContainerStateTerminatedBuilder(ContainerStateTerminatedFluent<?> fluent, ContainerStateTerminated instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withContainerID(instance.getContainerID());
        fluent.withExitCode(instance.getExitCode());
        fluent.withFinishedAt(instance.getFinishedAt());
        fluent.withMessage(instance.getMessage());
        fluent.withReason(instance.getReason());
        fluent.withSignal(instance.getSignal());
        fluent.withStartedAt(instance.getStartedAt());
        this.validationEnabled = validationEnabled;
    }

    public ContainerStateTerminatedBuilder(ContainerStateTerminated instance) {
        this(instance, (Boolean)true);
    }

    public ContainerStateTerminatedBuilder(ContainerStateTerminated instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withContainerID(instance.getContainerID());
        this.withExitCode(instance.getExitCode());
        this.withFinishedAt(instance.getFinishedAt());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.withSignal(instance.getSignal());
        this.withStartedAt(instance.getStartedAt());
        this.validationEnabled = validationEnabled;
    }

    public ContainerStateTerminatedBuilder(Validator validator) {
        this(new ContainerStateTerminated(), (Boolean)true);
    }

    public ContainerStateTerminatedBuilder(ContainerStateTerminatedFluent<?> fluent, ContainerStateTerminated instance, Validator validator) {
        this.fluent = fluent;
        fluent.withContainerID(instance.getContainerID());
        fluent.withExitCode(instance.getExitCode());
        fluent.withFinishedAt(instance.getFinishedAt());
        fluent.withMessage(instance.getMessage());
        fluent.withReason(instance.getReason());
        fluent.withSignal(instance.getSignal());
        fluent.withStartedAt(instance.getStartedAt());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ContainerStateTerminatedBuilder(ContainerStateTerminated instance, Validator validator) {
        this.fluent = this;
        this.withContainerID(instance.getContainerID());
        this.withExitCode(instance.getExitCode());
        this.withFinishedAt(instance.getFinishedAt());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.withSignal(instance.getSignal());
        this.withStartedAt(instance.getStartedAt());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ContainerStateTerminated build() {
        ContainerStateTerminated buildable = new ContainerStateTerminated(this.fluent.getContainerID(), this.fluent.getExitCode(), this.fluent.getFinishedAt(), this.fluent.getMessage(), this.fluent.getReason(), this.fluent.getSignal(), this.fluent.getStartedAt());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStateTerminatedBuilder that = (ContainerStateTerminatedBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

