/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_2.ContainerImage;
import io.fabric8.kubernetes.api.model.v4_2.ContainerImageFluent;
import io.fabric8.kubernetes.api.model.v4_2.ContainerImageFluentImpl;
import javax.validation.Validator;

public class ContainerImageBuilder
extends ContainerImageFluentImpl<ContainerImageBuilder>
implements VisitableBuilder<ContainerImage, ContainerImageBuilder> {
    ContainerImageFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ContainerImageBuilder() {
        this(true);
    }

    public ContainerImageBuilder(Boolean validationEnabled) {
        this(new ContainerImage(), validationEnabled);
    }

    public ContainerImageBuilder(ContainerImageFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ContainerImageBuilder(ContainerImageFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerImage(), validationEnabled);
    }

    public ContainerImageBuilder(ContainerImageFluent<?> fluent, ContainerImage instance) {
        this(fluent, instance, true);
    }

    public ContainerImageBuilder(ContainerImageFluent<?> fluent, ContainerImage instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNames(instance.getNames());
        fluent.withSizeBytes(instance.getSizeBytes());
        this.validationEnabled = validationEnabled;
    }

    public ContainerImageBuilder(ContainerImage instance) {
        this(instance, (Boolean)true);
    }

    public ContainerImageBuilder(ContainerImage instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNames(instance.getNames());
        this.withSizeBytes(instance.getSizeBytes());
        this.validationEnabled = validationEnabled;
    }

    public ContainerImageBuilder(Validator validator) {
        this(new ContainerImage(), (Boolean)true);
    }

    public ContainerImageBuilder(ContainerImageFluent<?> fluent, ContainerImage instance, Validator validator) {
        this.fluent = fluent;
        fluent.withNames(instance.getNames());
        fluent.withSizeBytes(instance.getSizeBytes());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ContainerImageBuilder(ContainerImage instance, Validator validator) {
        this.fluent = this;
        this.withNames(instance.getNames());
        this.withSizeBytes(instance.getSizeBytes());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ContainerImage build() {
        ContainerImage buildable = new ContainerImage(this.fluent.getNames(), this.fluent.getSizeBytes());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerImageBuilder that = (ContainerImageBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

