/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_2.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v4_2.ComponentStatusListFluent;
import io.fabric8.kubernetes.api.model.v4_2.ComponentStatusListFluentImpl;
import javax.validation.Validator;

public class ComponentStatusListBuilder
extends ComponentStatusListFluentImpl<ComponentStatusListBuilder>
implements VisitableBuilder<ComponentStatusList, ComponentStatusListBuilder> {
    ComponentStatusListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ComponentStatusListBuilder() {
        this(true);
    }

    public ComponentStatusListBuilder(Boolean validationEnabled) {
        this(new ComponentStatusList(), validationEnabled);
    }

    public ComponentStatusListBuilder(ComponentStatusListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ComponentStatusListBuilder(ComponentStatusListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ComponentStatusList(), validationEnabled);
    }

    public ComponentStatusListBuilder(ComponentStatusListFluent<?> fluent, ComponentStatusList instance) {
        this(fluent, instance, true);
    }

    public ComponentStatusListBuilder(ComponentStatusListFluent<?> fluent, ComponentStatusList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ComponentStatusListBuilder(ComponentStatusList instance) {
        this(instance, (Boolean)true);
    }

    public ComponentStatusListBuilder(ComponentStatusList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ComponentStatusListBuilder(Validator validator) {
        this(new ComponentStatusList(), (Boolean)true);
    }

    public ComponentStatusListBuilder(ComponentStatusListFluent<?> fluent, ComponentStatusList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ComponentStatusListBuilder(ComponentStatusList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ComponentStatusList build() {
        ComponentStatusList buildable = new ComponentStatusList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentStatusListBuilder that = (ComponentStatusListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

