/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.builder.v4_2;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public final class ValidationUtils {
    private static final Object LOCK = new Object();
    private static Validator validator;

    private static Validator createValidator() {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            return factory.getValidator();
        }
        catch (ValidationException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Validator getValidator() {
        Validator v = validator;
        if (v == null) {
            Object object = LOCK;
            synchronized (object) {
                v = validator;
                if (validator == null) {
                    validator = v = ValidationUtils.createValidator();
                }
            }
        }
        return v;
    }

    public static <T> void validate(T item) {
        ValidationUtils.validate(item, ValidationUtils.getValidator());
    }

    public static <T> void validate(T item, Validator v) {
        if (v == null) {
            v = ValidationUtils.getValidator();
        }
        if (v == null) {
            return;
        }
        Set violations = v.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder("Constraint Validations: ");
            boolean first = true;
            for (ConstraintViolation violation : violations) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                Object leafBean = violation.getLeafBean();
                sb.append(violation.getPropertyPath() + " " + violation.getMessage() + " on bean: " + leafBean);
            }
            throw new ConstraintViolationException(sb.toString(), violations);
        }
    }
}

