/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyPort;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyPortFluent;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyPortFluentImpl;
import javax.validation.Validator;

public class NetworkPolicyPortBuilder
extends NetworkPolicyPortFluentImpl<NetworkPolicyPortBuilder>
implements VisitableBuilder<NetworkPolicyPort, NetworkPolicyPortBuilder> {
    NetworkPolicyPortFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NetworkPolicyPortBuilder() {
        this(true);
    }

    public NetworkPolicyPortBuilder(Boolean validationEnabled) {
        this(new NetworkPolicyPort(), validationEnabled);
    }

    public NetworkPolicyPortBuilder(NetworkPolicyPortFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NetworkPolicyPortBuilder(NetworkPolicyPortFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkPolicyPort(), validationEnabled);
    }

    public NetworkPolicyPortBuilder(NetworkPolicyPortFluent<?> fluent, NetworkPolicyPort instance) {
        this(fluent, instance, true);
    }

    public NetworkPolicyPortBuilder(NetworkPolicyPortFluent<?> fluent, NetworkPolicyPort instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPort(instance.getPort());
        fluent.withProtocol(instance.getProtocol());
        this.validationEnabled = validationEnabled;
    }

    public NetworkPolicyPortBuilder(NetworkPolicyPort instance) {
        this(instance, (Boolean)true);
    }

    public NetworkPolicyPortBuilder(NetworkPolicyPort instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPort(instance.getPort());
        this.withProtocol(instance.getProtocol());
        this.validationEnabled = validationEnabled;
    }

    public NetworkPolicyPortBuilder(Validator validator) {
        this(new NetworkPolicyPort(), (Boolean)true);
    }

    public NetworkPolicyPortBuilder(NetworkPolicyPortFluent<?> fluent, NetworkPolicyPort instance, Validator validator) {
        this.fluent = fluent;
        fluent.withPort(instance.getPort());
        fluent.withProtocol(instance.getProtocol());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public NetworkPolicyPortBuilder(NetworkPolicyPort instance, Validator validator) {
        this.fluent = this;
        this.withPort(instance.getPort());
        this.withProtocol(instance.getProtocol());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public NetworkPolicyPort build() {
        NetworkPolicyPort buildable = new NetworkPolicyPort(this.fluent.getPort(), this.fluent.getProtocol());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicyPortBuilder that = (NetworkPolicyPortBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

