/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_2.server.mock;

import io.fabric8.kubernetes.clnt.v4_2.KubernetesClient;
import io.fabric8.kubernetes.clnt.v4_2.server.mock.KubernetesCrudDispatcher;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.MockServerExpectation;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import io.fabric8.openshift.clnt.v4_2.NamespacedOpenShiftClient;
import io.fabric8.openshift.clnt.v4_2.server.mock.OpenShiftMockServer;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.junit.rules.ExternalResource;

public class OpenShiftServer
extends ExternalResource {
    protected OpenShiftMockServer mock;
    private NamespacedOpenShiftClient client;
    private boolean https;
    private boolean curdMode;

    public OpenShiftServer() {
        this(true, false);
    }

    public OpenShiftServer(boolean https) {
        this(https, false);
    }

    public OpenShiftServer(boolean https, boolean curdMode) {
        this.https = https;
        this.curdMode = curdMode;
    }

    public void before() {
        this.mock = this.curdMode ? new OpenShiftMockServer(new Context(), new MockWebServer(), new HashMap<ServerRequest, Queue<ServerResponse>>(), (Dispatcher)new KubernetesCrudDispatcher(), true) : new OpenShiftMockServer(this.https);
        this.mock.init();
        this.client = this.mock.createOpenShiftClient();
    }

    public void after() {
        this.mock.destroy();
        this.client.close();
    }

    public KubernetesClient getKubernetesClient() {
        return this.client;
    }

    public NamespacedOpenShiftClient getOpenshiftClient() {
        return this.client;
    }

    public MockServerExpectation expect() {
        return this.mock.expect();
    }

    @Deprecated
    public <T> void expectAndReturnAsJson(String path, int code, T body) {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)this.expect().withPath(path)).andReturn(code, body)).always();
    }

    @Deprecated
    public void expectAndReturnAsString(String path, int code, String body) {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)this.expect().withPath(path)).andReturn(code, (Object)body)).always();
    }

    public MockWebServer getMockServer() {
        return this.mock.getServer();
    }

    public RecordedRequest getLastRequest() throws InterruptedException {
        int count = this.mock.getServer().getRequestCount();
        RecordedRequest request = null;
        while (count-- > 0) {
            request = this.mock.getServer().takeRequest();
        }
        return request;
    }
}

