/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_2;

import io.fabric8.kubernetes.api.model.v4_2.ComponentStatus;
import io.fabric8.kubernetes.api.model.v4_2.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v4_2.ConfigMap;
import io.fabric8.kubernetes.api.model.v4_2.ConfigMapList;
import io.fabric8.kubernetes.api.model.v4_2.Doneable;
import io.fabric8.kubernetes.api.model.v4_2.DoneableComponentStatus;
import io.fabric8.kubernetes.api.model.v4_2.DoneableConfigMap;
import io.fabric8.kubernetes.api.model.v4_2.DoneableEndpoints;
import io.fabric8.kubernetes.api.model.v4_2.DoneableEvent;
import io.fabric8.kubernetes.api.model.v4_2.DoneableLimitRange;
import io.fabric8.kubernetes.api.model.v4_2.DoneableNamespace;
import io.fabric8.kubernetes.api.model.v4_2.DoneableNode;
import io.fabric8.kubernetes.api.model.v4_2.DoneablePersistentVolume;
import io.fabric8.kubernetes.api.model.v4_2.DoneablePersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v4_2.DoneablePod;
import io.fabric8.kubernetes.api.model.v4_2.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.v4_2.DoneableResourceQuota;
import io.fabric8.kubernetes.api.model.v4_2.DoneableSecret;
import io.fabric8.kubernetes.api.model.v4_2.DoneableService;
import io.fabric8.kubernetes.api.model.v4_2.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.v4_2.Endpoints;
import io.fabric8.kubernetes.api.model.v4_2.EndpointsList;
import io.fabric8.kubernetes.api.model.v4_2.Event;
import io.fabric8.kubernetes.api.model.v4_2.EventList;
import io.fabric8.kubernetes.api.model.v4_2.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_2.KubernetesList;
import io.fabric8.kubernetes.api.model.v4_2.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v4_2.LimitRange;
import io.fabric8.kubernetes.api.model.v4_2.LimitRangeList;
import io.fabric8.kubernetes.api.model.v4_2.Namespace;
import io.fabric8.kubernetes.api.model.v4_2.NamespaceList;
import io.fabric8.kubernetes.api.model.v4_2.Node;
import io.fabric8.kubernetes.api.model.v4_2.NodeList;
import io.fabric8.kubernetes.api.model.v4_2.PersistentVolume;
import io.fabric8.kubernetes.api.model.v4_2.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v4_2.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.v4_2.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.v4_2.Pod;
import io.fabric8.kubernetes.api.model.v4_2.PodList;
import io.fabric8.kubernetes.api.model.v4_2.ReplicationController;
import io.fabric8.kubernetes.api.model.v4_2.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v4_2.ResourceQuota;
import io.fabric8.kubernetes.api.model.v4_2.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.v4_2.RootPaths;
import io.fabric8.kubernetes.api.model.v4_2.Secret;
import io.fabric8.kubernetes.api.model.v4_2.SecretList;
import io.fabric8.kubernetes.api.model.v4_2.Service;
import io.fabric8.kubernetes.api.model.v4_2.ServiceAccount;
import io.fabric8.kubernetes.api.model.v4_2.ServiceAccountList;
import io.fabric8.kubernetes.api.model.v4_2.ServiceList;
import io.fabric8.kubernetes.api.model.v4_2.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.v4_2.apiextensions.CustomResourceDefinitionList;
import io.fabric8.kubernetes.api.model.v4_2.apiextensions.DoneableCustomResourceDefinition;
import io.fabric8.kubernetes.clnt.v4_2.AppsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_2.AutoscalingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_2.BaseClient;
import io.fabric8.kubernetes.clnt.v4_2.BatchAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_2.Config;
import io.fabric8.kubernetes.clnt.v4_2.DefaultKubernetesClient;
import io.fabric8.kubernetes.clnt.v4_2.ExtensionsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_2.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_2.NamespacedKubernetesClient;
import io.fabric8.kubernetes.clnt.v4_2.NetworkAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_2.PolicyAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_2.RbacAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_2.RequestConfig;
import io.fabric8.kubernetes.clnt.v4_2.SchedulingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_2.SettingsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_2.StorageAPIGroupClient;
import io.fabric8.kubernetes.clnt.v4_2.VersionInfo;
import io.fabric8.kubernetes.clnt.v4_2.WithRequestCallable;
import io.fabric8.kubernetes.clnt.v4_2.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_2.dsl.AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_2.dsl.BatchAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_2.dsl.FunctionCallable;
import io.fabric8.kubernetes.clnt.v4_2.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.clnt.v4_2.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v4_2.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v4_2.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_2.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_2.dsl.NetworkAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_2.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v4_2.dsl.ParameterMixedOperation;
import io.fabric8.kubernetes.clnt.v4_2.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_2.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v4_2.dsl.PolicyAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_2.dsl.RbacAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_2.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_2.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v4_2.dsl.SchedulingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_2.dsl.ServiceResource;
import io.fabric8.kubernetes.clnt.v4_2.dsl.SettingsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_2.dsl.StorageAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v4_2.dsl.internal.ClusterOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_2.dsl.internal.ComponentStatusOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_2.dsl.internal.CustomResourceDefinitionOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_2.dsl.internal.CustomResourceOperationContext;
import io.fabric8.kubernetes.clnt.v4_2.dsl.internal.CustomResourceOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_2.utils.BackwardsCompatibilityInterceptor;
import io.fabric8.kubernetes.clnt.v4_2.utils.ImpersonatorInterceptor;
import io.fabric8.kubernetes.clnt.v4_2.utils.Serialization;
import io.fabric8.openshift.api.model.v4_2.Build;
import io.fabric8.openshift.api.model.v4_2.BuildConfig;
import io.fabric8.openshift.api.model.v4_2.BuildConfigList;
import io.fabric8.openshift.api.model.v4_2.BuildList;
import io.fabric8.openshift.api.model.v4_2.DeploymentConfig;
import io.fabric8.openshift.api.model.v4_2.DeploymentConfigList;
import io.fabric8.openshift.api.model.v4_2.DoneableBuild;
import io.fabric8.openshift.api.model.v4_2.DoneableBuildConfig;
import io.fabric8.openshift.api.model.v4_2.DoneableDeploymentConfig;
import io.fabric8.openshift.api.model.v4_2.DoneableGroup;
import io.fabric8.openshift.api.model.v4_2.DoneableImageStream;
import io.fabric8.openshift.api.model.v4_2.DoneableImageStreamTag;
import io.fabric8.openshift.api.model.v4_2.DoneableOAuthAccessToken;
import io.fabric8.openshift.api.model.v4_2.DoneableOAuthAuthorizeToken;
import io.fabric8.openshift.api.model.v4_2.DoneableOAuthClient;
import io.fabric8.openshift.api.model.v4_2.DoneableOpenshiftClusterRoleBinding;
import io.fabric8.openshift.api.model.v4_2.DoneableOpenshiftRole;
import io.fabric8.openshift.api.model.v4_2.DoneableOpenshiftRoleBinding;
import io.fabric8.openshift.api.model.v4_2.DoneableProject;
import io.fabric8.openshift.api.model.v4_2.DoneableRoute;
import io.fabric8.openshift.api.model.v4_2.DoneableSecurityContextConstraints;
import io.fabric8.openshift.api.model.v4_2.DoneableTemplate;
import io.fabric8.openshift.api.model.v4_2.DoneableUser;
import io.fabric8.openshift.api.model.v4_2.Group;
import io.fabric8.openshift.api.model.v4_2.GroupList;
import io.fabric8.openshift.api.model.v4_2.ImageStream;
import io.fabric8.openshift.api.model.v4_2.ImageStreamList;
import io.fabric8.openshift.api.model.v4_2.ImageStreamTag;
import io.fabric8.openshift.api.model.v4_2.ImageStreamTagList;
import io.fabric8.openshift.api.model.v4_2.OAuthAccessToken;
import io.fabric8.openshift.api.model.v4_2.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.v4_2.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.v4_2.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.v4_2.OAuthClient;
import io.fabric8.openshift.api.model.v4_2.OAuthClientList;
import io.fabric8.openshift.api.model.v4_2.OpenshiftClusterRoleBinding;
import io.fabric8.openshift.api.model.v4_2.OpenshiftClusterRoleBindingList;
import io.fabric8.openshift.api.model.v4_2.OpenshiftRole;
import io.fabric8.openshift.api.model.v4_2.OpenshiftRoleBinding;
import io.fabric8.openshift.api.model.v4_2.OpenshiftRoleBindingList;
import io.fabric8.openshift.api.model.v4_2.OpenshiftRoleList;
import io.fabric8.openshift.api.model.v4_2.Project;
import io.fabric8.openshift.api.model.v4_2.ProjectList;
import io.fabric8.openshift.api.model.v4_2.Route;
import io.fabric8.openshift.api.model.v4_2.RouteList;
import io.fabric8.openshift.api.model.v4_2.SecurityContextConstraints;
import io.fabric8.openshift.api.model.v4_2.SecurityContextConstraintsList;
import io.fabric8.openshift.api.model.v4_2.Template;
import io.fabric8.openshift.api.model.v4_2.TemplateList;
import io.fabric8.openshift.api.model.v4_2.User;
import io.fabric8.openshift.api.model.v4_2.UserList;
import io.fabric8.openshift.clnt.v4_2.NamespacedOpenShiftClient;
import io.fabric8.openshift.clnt.v4_2.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_2.OpenShiftConfigBuilder;
import io.fabric8.openshift.clnt.v4_2.dsl.BuildConfigResource;
import io.fabric8.openshift.clnt.v4_2.dsl.BuildResource;
import io.fabric8.openshift.clnt.v4_2.dsl.CreateableLocalSubjectAccessReview;
import io.fabric8.openshift.clnt.v4_2.dsl.CreateableSubjectAccessReview;
import io.fabric8.openshift.clnt.v4_2.dsl.DeployableScalableResource;
import io.fabric8.openshift.clnt.v4_2.dsl.ProjectRequestOperation;
import io.fabric8.openshift.clnt.v4_2.dsl.SubjectAccessReviewOperation;
import io.fabric8.openshift.clnt.v4_2.dsl.TemplateResource;
import io.fabric8.openshift.clnt.v4_2.dsl.internal.BuildConfigOperationsImpl;
import io.fabric8.openshift.clnt.v4_2.dsl.internal.BuildOperationsImpl;
import io.fabric8.openshift.clnt.v4_2.dsl.internal.DeploymentConfigOperationsImpl;
import io.fabric8.openshift.clnt.v4_2.dsl.internal.GroupOperationsImpl;
import io.fabric8.openshift.clnt.v4_2.dsl.internal.ImageStreamOperationsImpl;
import io.fabric8.openshift.clnt.v4_2.dsl.internal.ImageStreamTagOperationsImpl;
import io.fabric8.openshift.clnt.v4_2.dsl.internal.OAuthAccessTokenOperationsImpl;
import io.fabric8.openshift.clnt.v4_2.dsl.internal.OAuthAuthorizeTokenOperationsImpl;
import io.fabric8.openshift.clnt.v4_2.dsl.internal.OAuthClientOperationsImpl;
import io.fabric8.openshift.clnt.v4_2.dsl.internal.OpenshiftClusterRoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v4_2.dsl.internal.OpenshiftRoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v4_2.dsl.internal.OpenshiftRoleOperationsImpl;
import io.fabric8.openshift.clnt.v4_2.dsl.internal.ProjectOperationsImpl;
import io.fabric8.openshift.clnt.v4_2.dsl.internal.ProjectRequestsOperationImpl;
import io.fabric8.openshift.clnt.v4_2.dsl.internal.RouteOperationsImpl;
import io.fabric8.openshift.clnt.v4_2.dsl.internal.SecurityContextConstraintsOperationsImpl;
import io.fabric8.openshift.clnt.v4_2.dsl.internal.SubjectAccessReviewOperationImpl;
import io.fabric8.openshift.clnt.v4_2.dsl.internal.TemplateOperationsImpl;
import io.fabric8.openshift.clnt.v4_2.dsl.internal.UserOperationsImpl;
import io.fabric8.openshift.clnt.v4_2.internal.OpenShiftOAuthInterceptor;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class DefaultOpenShiftClient
extends BaseClient
implements NamespacedOpenShiftClient {
    private URL openShiftUrl;
    private NamespacedKubernetesClient delegate;

    public DefaultOpenShiftClient() throws KubernetesClientException {
        this(new OpenShiftConfigBuilder().build());
    }

    public DefaultOpenShiftClient(String masterUrl) throws KubernetesClientException {
        this(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    public DefaultOpenShiftClient(Config config) throws KubernetesClientException {
        this(new OpenShiftConfig(config));
    }

    public DefaultOpenShiftClient(OpenShiftConfig config) throws KubernetesClientException {
        super(config);
        try {
            this.httpClient = this.clientWithOpenShiftOAuthInterceptor(this.httpClient);
            this.delegate = new DefaultKubernetesClient(this.httpClient, config);
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", e);
        }
    }

    public DefaultOpenShiftClient(OkHttpClient httpClient, OpenShiftConfig config) throws KubernetesClientException {
        super(httpClient, config);
        try {
            this.httpClient = this.clientWithOpenShiftOAuthInterceptor(httpClient);
            this.delegate = new DefaultKubernetesClient(this.httpClient, config);
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", e);
        }
    }

    public static DefaultOpenShiftClient fromConfig(String config) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(config, OpenShiftConfig.class));
    }

    public static DefaultOpenShiftClient fromConfig(InputStream is) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(is, OpenShiftConfig.class));
    }

    private OkHttpClient clientWithOpenShiftOAuthInterceptor(OkHttpClient httpClient) {
        httpClient = httpClient.newBuilder().authenticator(Authenticator.NONE).build();
        OkHttpClient.Builder builder = httpClient.newBuilder();
        builder.interceptors().clear();
        return builder.addInterceptor((Interceptor)new OpenShiftOAuthInterceptor(httpClient, OpenShiftConfig.wrap(this.getConfiguration()))).addInterceptor((Interceptor)new ImpersonatorInterceptor(this.getConfiguration())).addInterceptor((Interceptor)new BackwardsCompatibilityInterceptor()).build();
    }

    @Override
    public URL getOpenshiftUrl() {
        return this.openShiftUrl;
    }

    @Override
    public MixedOperation<ComponentStatus, ComponentStatusList, DoneableComponentStatus, Resource<ComponentStatus, DoneableComponentStatus>> componentstatuses() {
        return new ComponentStatusOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> load(InputStream is) {
        return this.delegate.load(is);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(HasMetadata item) {
        return this.delegate.resource(item);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(String s) {
        return this.delegate.resource(s);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(KubernetesResourceList is) {
        return this.delegate.resourceList(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(HasMetadata ... items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(Collection<HasMetadata> items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(String s) {
        return this.delegate.resourceList(s);
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, DoneableEndpoints, Resource<Endpoints, DoneableEndpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public MixedOperation<Event, EventList, DoneableEvent, Resource<Event, DoneableEvent>> events() {
        return this.delegate.events();
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, DoneableNamespace, Resource<Namespace, DoneableNamespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, DoneableNode, Resource<Node, DoneableNode>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, Resource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, Resource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, RollableScalableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, Resource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public MixedOperation<Secret, SecretList, DoneableSecret, Resource<Secret, DoneableSecret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public MixedOperation<Service, ServiceList, DoneableService, ServiceResource<Service, DoneableService>> services() {
        return this.delegate.services();
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, Resource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, Resource<ConfigMap, DoneableConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, DoneableLimitRange, Resource<LimitRange, DoneableLimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResources(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return new CustomResourceOperationsImpl(new CustomResourceOperationContext().withOkhttpClient(this.httpClient).withConfig(this.getConfiguration()).withCrd(crd).withType(resourceType).withListType(listClass).withDoneableType(doneClass));
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResource(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return this.customResources(crd, resourceType, listClass, doneClass);
    }

    @Override
    public NonNamespaceOperation<CustomResourceDefinition, CustomResourceDefinitionList, DoneableCustomResourceDefinition, Resource<CustomResourceDefinition, DoneableCustomResourceDefinition>> customResourceDefinitions() {
        return new CustomResourceDefinitionOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<Build, BuildList, DoneableBuild, BuildResource<Build, DoneableBuild, String, LogWatch>> builds() {
        return new BuildOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<BuildConfig, BuildConfigList, DoneableBuildConfig, BuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Build>> buildConfigs() {
        return new BuildConfigOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<DeploymentConfig, DeploymentConfigList, DoneableDeploymentConfig, DeployableScalableResource<DeploymentConfig, DoneableDeploymentConfig>> deploymentConfigs() {
        return new DeploymentConfigOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    public MixedOperation<Group, GroupList, DoneableGroup, Resource<Group, DoneableGroup>> groups() {
        return new GroupOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<ImageStream, ImageStreamList, DoneableImageStream, Resource<ImageStream, DoneableImageStream>> imageStreams() {
        return new ImageStreamOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<ImageStreamTag, ImageStreamTagList, DoneableImageStreamTag, Resource<ImageStreamTag, DoneableImageStreamTag>> imageStreamTags() {
        return new ImageStreamTagOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, DoneableOAuthAccessToken, Resource<OAuthAccessToken, DoneableOAuthAccessToken>> oAuthAccessTokens() {
        return new OAuthAccessTokenOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, DoneableOAuthAuthorizeToken, Resource<OAuthAuthorizeToken, DoneableOAuthAuthorizeToken>> oAuthAuthorizeTokens() {
        return new OAuthAuthorizeTokenOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuthClient, OAuthClientList, DoneableOAuthClient, Resource<OAuthClient, DoneableOAuthClient>> oAuthClients() {
        return new OAuthClientOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Project, ProjectList, DoneableProject, Resource<Project, DoneableProject>> projects() {
        return new ProjectOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, DoneableSecurityContextConstraints, Resource<SecurityContextConstraints, DoneableSecurityContextConstraints>> securityContextConstraints() {
        return new SecurityContextConstraintsOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public ProjectRequestOperation projectrequests() {
        return new ProjectRequestsOperationImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<OpenshiftRole, OpenshiftRoleList, DoneableOpenshiftRole, Resource<OpenshiftRole, DoneableOpenshiftRole>> roles() {
        return new OpenshiftRoleOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<OpenshiftRoleBinding, OpenshiftRoleBindingList, DoneableOpenshiftRoleBinding, Resource<OpenshiftRoleBinding, DoneableOpenshiftRoleBinding>> roleBindings() {
        return new OpenshiftRoleBindingOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<Route, RouteList, DoneableRoute, Resource<Route, DoneableRoute>> routes() {
        return new RouteOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public ParameterMixedOperation<Template, TemplateList, DoneableTemplate, TemplateResource<Template, KubernetesList, DoneableTemplate>> templates() {
        return new TemplateOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    public MixedOperation<User, UserList, DoneableUser, Resource<User, DoneableUser>> users() {
        return new UserOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public SubjectAccessReviewOperation<CreateableSubjectAccessReview, CreateableLocalSubjectAccessReview> subjectAccessReviews() {
        return new SubjectAccessReviewOperationImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<OpenshiftClusterRoleBinding, OpenshiftClusterRoleBindingList, DoneableOpenshiftClusterRoleBinding, Resource<OpenshiftClusterRoleBinding, DoneableOpenshiftClusterRoleBinding>> clusterRoleBindings() {
        return new OpenshiftClusterRoleBindingOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NamespacedOpenShiftClient inNamespace(String namespace) {
        OpenShiftConfig updated = ((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(new OpenShiftConfig(this.getConfiguration())).withOpenShiftUrl(this.openShiftUrl.toString())).withNamespace(namespace)).build();
        return new DefaultOpenShiftClient(this.httpClient, updated);
    }

    @Override
    public NamespacedOpenShiftClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    @Override
    public ExtensionsAPIGroupClient extensions() {
        return this.adapt(ExtensionsAPIGroupClient.class);
    }

    @Override
    public VersionInfo getVersion() {
        return new ClusterOperationsImpl(this.httpClient, this.getConfiguration(), "version/openshift").fetchVersion();
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.adapt(AppsAPIGroupClient.class);
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.adapt(AutoscalingAPIGroupClient.class);
    }

    @Override
    public NetworkAPIGroupDSL network() {
        return this.adapt(NetworkAPIGroupClient.class);
    }

    @Override
    public StorageAPIGroupDSL storage() {
        return this.adapt(StorageAPIGroupClient.class);
    }

    @Override
    public SettingsAPIGroupDSL settings() {
        return this.adapt(SettingsAPIGroupClient.class);
    }

    @Override
    public BatchAPIGroupDSL batch() {
        return this.adapt(BatchAPIGroupClient.class);
    }

    @Override
    public PolicyAPIGroupDSL policy() {
        return this.adapt(PolicyAPIGroupClient.class);
    }

    @Override
    public RbacAPIGroupDSL rbac() {
        return this.adapt(RbacAPIGroupClient.class);
    }

    @Override
    public SchedulingAPIGroupDSL scheduling() {
        return this.adapt(SchedulingAPIGroupClient.class);
    }

    @Override
    public FunctionCallable<NamespacedOpenShiftClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable<NamespacedOpenShiftClient>(this, requestConfig);
    }

    @Override
    public User currentUser() {
        return (User)((Resource)this.users().withName("~")).get();
    }

    @Override
    public boolean supportsOpenShiftAPIGroup(String apiGroup) {
        List<String> paths;
        String apiGroupPath = "/apis/" + apiGroup;
        RootPaths rootPaths = this.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!Objects.equals("/oapi", path) && !Objects.equals("oapi", path) && !Objects.equals(apiGroupPath, path)) continue;
                return true;
            }
        }
        return false;
    }
}

