/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_2.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.v4_2.OAuthClientAuthorizationFluent;
import io.fabric8.openshift.api.model.v4_2.OAuthClientAuthorizationFluentImpl;
import javax.validation.Validator;

public class OAuthClientAuthorizationBuilder
extends OAuthClientAuthorizationFluentImpl<OAuthClientAuthorizationBuilder>
implements VisitableBuilder<OAuthClientAuthorization, OAuthClientAuthorizationBuilder> {
    OAuthClientAuthorizationFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public OAuthClientAuthorizationBuilder() {
        this(true);
    }

    public OAuthClientAuthorizationBuilder(Boolean validationEnabled) {
        this(new OAuthClientAuthorization(), validationEnabled);
    }

    public OAuthClientAuthorizationBuilder(OAuthClientAuthorizationFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public OAuthClientAuthorizationBuilder(OAuthClientAuthorizationFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new OAuthClientAuthorization(), validationEnabled);
    }

    public OAuthClientAuthorizationBuilder(OAuthClientAuthorizationFluent<?> fluent, OAuthClientAuthorization instance) {
        this(fluent, instance, true);
    }

    public OAuthClientAuthorizationBuilder(OAuthClientAuthorizationFluent<?> fluent, OAuthClientAuthorization instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withClientName(instance.getClientName());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withScopes(instance.getScopes());
        fluent.withUserName(instance.getUserName());
        fluent.withUserUID(instance.getUserUID());
        this.validationEnabled = validationEnabled;
    }

    public OAuthClientAuthorizationBuilder(OAuthClientAuthorization instance) {
        this(instance, (Boolean)true);
    }

    public OAuthClientAuthorizationBuilder(OAuthClientAuthorization instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withClientName(instance.getClientName());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withScopes(instance.getScopes());
        this.withUserName(instance.getUserName());
        this.withUserUID(instance.getUserUID());
        this.validationEnabled = validationEnabled;
    }

    public OAuthClientAuthorizationBuilder(Validator validator) {
        this(new OAuthClientAuthorization(), (Boolean)true);
    }

    public OAuthClientAuthorizationBuilder(OAuthClientAuthorizationFluent<?> fluent, OAuthClientAuthorization instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withClientName(instance.getClientName());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withScopes(instance.getScopes());
        fluent.withUserName(instance.getUserName());
        fluent.withUserUID(instance.getUserUID());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public OAuthClientAuthorizationBuilder(OAuthClientAuthorization instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withClientName(instance.getClientName());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withScopes(instance.getScopes());
        this.withUserName(instance.getUserName());
        this.withUserUID(instance.getUserUID());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public OAuthClientAuthorization build() {
        OAuthClientAuthorization buildable = new OAuthClientAuthorization(this.fluent.getApiVersion(), this.fluent.getClientName(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getScopes(), this.fluent.getUserName(), this.fluent.getUserUID());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuthClientAuthorizationBuilder that = (OAuthClientAuthorizationBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

