/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_2.Nested;
import io.fabric8.kubernetes.api.builder.v4_2.Predicate;
import io.fabric8.kubernetes.api.model.v4_2.LabelSelector;
import io.fabric8.kubernetes.api.model.v4_2.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v4_2.LabelSelectorFluentImpl;
import io.fabric8.openshift.api.model.v4_2.GroupRestriction;
import io.fabric8.openshift.api.model.v4_2.GroupRestrictionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GroupRestrictionFluentImpl<A extends GroupRestrictionFluent<A>>
extends BaseFluent<A>
implements GroupRestrictionFluent<A> {
    private List<String> groups;
    private List<LabelSelectorBuilder> labels;

    public GroupRestrictionFluentImpl() {
    }

    public GroupRestrictionFluentImpl(GroupRestriction instance) {
        this.withGroups(instance.getGroups());
        this.withLabels(instance.getLabels());
    }

    @Override
    public A addToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroups(String ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroups(Collection<String> items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroups(String ... items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroups(Collection<String> items) {
        for (String item : items) {
            if (this.groups == null) continue;
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public String getGroup(int index) {
        return this.groups.get(index);
    }

    @Override
    public String getFirstGroup() {
        return this.groups.get(0);
    }

    @Override
    public String getLastGroup() {
        return this.groups.get(this.groups.size() - 1);
    }

    @Override
    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGroups(List<String> groups) {
        if (this.groups != null) {
            this._visitables.get("groups").removeAll(this.groups);
        }
        if (groups != null) {
            this.groups = new ArrayList<String>();
            for (String item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = new ArrayList<String>();
        }
        return (A)this;
    }

    @Override
    public A withGroups(String ... groups) {
        if (this.groups != null) {
            this.groups.clear();
        }
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    @Override
    public A addNewGroup(String arg1) {
        return this.addToGroups(new String(arg1));
    }

    @Override
    public A addNewGroup(StringBuilder arg1) {
        return this.addToGroups(new String(arg1));
    }

    @Override
    public A addNewGroup(StringBuffer arg1) {
        return this.addToGroups(new String(arg1));
    }

    @Override
    public A addToLabels(int index, LabelSelector item) {
        if (this.labels == null) {
            this.labels = new ArrayList<LabelSelectorBuilder>();
        }
        LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
        this._visitables.get("labels").add(index >= 0 ? index : this._visitables.get("labels").size(), builder);
        this.labels.add(index >= 0 ? index : this.labels.size(), builder);
        return (A)this;
    }

    @Override
    public A setToLabels(int index, LabelSelector item) {
        if (this.labels == null) {
            this.labels = new ArrayList<LabelSelectorBuilder>();
        }
        LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
        if (index < 0 || index >= this._visitables.get("labels").size()) {
            this._visitables.get("labels").add(builder);
        } else {
            this._visitables.get("labels").set(index, builder);
        }
        if (index < 0 || index >= this.labels.size()) {
            this.labels.add(builder);
        } else {
            this.labels.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(LabelSelector ... items) {
        if (this.labels == null) {
            this.labels = new ArrayList<LabelSelectorBuilder>();
        }
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get("labels").add(builder);
            this.labels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToLabels(Collection<LabelSelector> items) {
        if (this.labels == null) {
            this.labels = new ArrayList<LabelSelectorBuilder>();
        }
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get("labels").add(builder);
            this.labels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(LabelSelector ... items) {
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get("labels").remove(builder);
            if (this.labels == null) continue;
            this.labels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLabels(Collection<LabelSelector> items) {
        for (LabelSelector item : items) {
            LabelSelectorBuilder builder = new LabelSelectorBuilder(item);
            this._visitables.get("labels").remove(builder);
            if (this.labels == null) continue;
            this.labels.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<LabelSelector> getLabels() {
        return GroupRestrictionFluentImpl.build(this.labels);
    }

    @Override
    public List<LabelSelector> buildLabels() {
        return GroupRestrictionFluentImpl.build(this.labels);
    }

    @Override
    public LabelSelector buildLabel(int index) {
        return this.labels.get(index).build();
    }

    @Override
    public LabelSelector buildFirstLabel() {
        return this.labels.get(0).build();
    }

    @Override
    public LabelSelector buildLastLabel() {
        return this.labels.get(this.labels.size() - 1).build();
    }

    @Override
    public LabelSelector buildMatchingLabel(Predicate<LabelSelectorBuilder> predicate) {
        for (LabelSelectorBuilder item : this.labels) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingLabel(Predicate<LabelSelectorBuilder> predicate) {
        for (LabelSelectorBuilder item : this.labels) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withLabels(List<LabelSelector> labels) {
        if (this.labels != null) {
            this._visitables.get("labels").removeAll(this.labels);
        }
        if (labels != null) {
            this.labels = new ArrayList<LabelSelectorBuilder>();
            for (LabelSelector item : labels) {
                this.addToLabels(item);
            }
        } else {
            this.labels = new ArrayList<LabelSelectorBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withLabels(LabelSelector ... labels) {
        if (this.labels != null) {
            this.labels.clear();
        }
        if (labels != null) {
            for (LabelSelector item : labels) {
                this.addToLabels(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null && !this.labels.isEmpty();
    }

    @Override
    public GroupRestrictionFluent.LabelsNested<A> addNewLabel() {
        return new LabelsNestedImpl();
    }

    @Override
    public GroupRestrictionFluent.LabelsNested<A> addNewLabelLike(LabelSelector item) {
        return new LabelsNestedImpl(-1, item);
    }

    @Override
    public GroupRestrictionFluent.LabelsNested<A> setNewLabelLike(int index, LabelSelector item) {
        return new LabelsNestedImpl(index, item);
    }

    @Override
    public GroupRestrictionFluent.LabelsNested<A> editLabel(int index) {
        if (this.labels.size() <= index) {
            throw new RuntimeException("Can't edit labels. Index exceeds size.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    @Override
    public GroupRestrictionFluent.LabelsNested<A> editFirstLabel() {
        if (this.labels.size() == 0) {
            throw new RuntimeException("Can't edit first labels. The list is empty.");
        }
        return this.setNewLabelLike(0, this.buildLabel(0));
    }

    @Override
    public GroupRestrictionFluent.LabelsNested<A> editLastLabel() {
        int index = this.labels.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last labels. The list is empty.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    @Override
    public GroupRestrictionFluent.LabelsNested<A> editMatchingLabel(Predicate<LabelSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.labels.size(); ++i) {
            if (!predicate.apply(this.labels.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching labels. No match found.");
        }
        return this.setNewLabelLike(index, this.buildLabel(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupRestrictionFluentImpl that = (GroupRestrictionFluentImpl)o;
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        return !(this.labels != null ? !this.labels.equals(that.labels) : that.labels != null);
    }

    public class LabelsNestedImpl<N>
    extends LabelSelectorFluentImpl<GroupRestrictionFluent.LabelsNested<N>>
    implements GroupRestrictionFluent.LabelsNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;
        private final int index;

        LabelsNestedImpl(int index, LabelSelector item) {
            this.index = index;
            this.builder = new LabelSelectorBuilder(this, item);
        }

        LabelsNestedImpl() {
            this.index = -1;
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)GroupRestrictionFluentImpl.this.setToLabels(this.index, this.builder.build());
        }

        @Override
        public N endLabel() {
            return this.and();
        }
    }
}

