/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_2.server.mock;

import io.fabric8.kubernetes.api.model.v4_2.RootPathsBuilder;
import io.fabric8.kubernetes.clnt.v4_2.Config;
import io.fabric8.kubernetes.clnt.v4_2.ConfigBuilder;
import io.fabric8.kubernetes.clnt.v4_2.DefaultKubernetesClient;
import io.fabric8.kubernetes.clnt.v4_2.NamespacedKubernetesClient;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ContextBuilder;
import io.fabric8.mockwebserver.DefaultMockServer;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.DelayPathable;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import okhttp3.TlsVersion;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;

public class KubernetesMockServer
extends DefaultMockServer {
    private static final Context context = new ContextBuilder().build();

    public KubernetesMockServer() {
        this(true);
    }

    public KubernetesMockServer(boolean useHttps) {
        this(new MockWebServer(), new HashMap<ServerRequest, Queue<ServerResponse>>(), useHttps);
    }

    public KubernetesMockServer(MockWebServer server, Map<ServerRequest, Queue<ServerResponse>> responses, boolean useHttps) {
        this(context, server, responses, useHttps);
    }

    public KubernetesMockServer(Context context, MockWebServer server, Map<ServerRequest, Queue<ServerResponse>> responses, boolean useHttps) {
        super(context, server, responses, useHttps);
    }

    public KubernetesMockServer(Context context, MockWebServer server, Map<ServerRequest, Queue<ServerResponse>> responses, Dispatcher dispatcher, boolean useHttps) {
        super(context, server, responses, dispatcher, useHttps);
    }

    public void init() {
        this.start();
    }

    public void destroy() {
        this.shutdown();
    }

    public void onStart() {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)this.expect().get()).withPath("/")).andReturn(200, (Object)((RootPathsBuilder)new RootPathsBuilder().addToPaths(this.getRootPaths())).build())).always();
    }

    public String[] getRootPaths() {
        return new String[]{"/api", "/apis/extensions"};
    }

    public NamespacedKubernetesClient createClient() {
        Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(this.url("/"))).withTrustCerts(true)).withTlsVersions(TlsVersion.TLS_1_0)).withNamespace("test")).build();
        return new DefaultKubernetesClient(config);
    }
}

