/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2.extensions;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_2.extensions.ScaleStatus;
import io.fabric8.kubernetes.api.model.v4_2.extensions.ScaleStatusFluent;
import io.fabric8.kubernetes.api.model.v4_2.extensions.ScaleStatusFluentImpl;
import javax.validation.Validator;

public class ScaleStatusBuilder
extends ScaleStatusFluentImpl<ScaleStatusBuilder>
implements VisitableBuilder<ScaleStatus, ScaleStatusBuilder> {
    ScaleStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ScaleStatusBuilder() {
        this(true);
    }

    public ScaleStatusBuilder(Boolean validationEnabled) {
        this(new ScaleStatus(), validationEnabled);
    }

    public ScaleStatusBuilder(ScaleStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ScaleStatusBuilder(ScaleStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ScaleStatus(), validationEnabled);
    }

    public ScaleStatusBuilder(ScaleStatusFluent<?> fluent, ScaleStatus instance) {
        this(fluent, instance, true);
    }

    public ScaleStatusBuilder(ScaleStatusFluent<?> fluent, ScaleStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withReplicas(instance.getReplicas());
        fluent.withSelector(instance.getSelector());
        fluent.withTargetSelector(instance.getTargetSelector());
        this.validationEnabled = validationEnabled;
    }

    public ScaleStatusBuilder(ScaleStatus instance) {
        this(instance, (Boolean)true);
    }

    public ScaleStatusBuilder(ScaleStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withReplicas(instance.getReplicas());
        this.withSelector(instance.getSelector());
        this.withTargetSelector(instance.getTargetSelector());
        this.validationEnabled = validationEnabled;
    }

    public ScaleStatusBuilder(Validator validator) {
        this(new ScaleStatus(), (Boolean)true);
    }

    public ScaleStatusBuilder(ScaleStatusFluent<?> fluent, ScaleStatus instance, Validator validator) {
        this.fluent = fluent;
        fluent.withReplicas(instance.getReplicas());
        fluent.withSelector(instance.getSelector());
        fluent.withTargetSelector(instance.getTargetSelector());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ScaleStatusBuilder(ScaleStatus instance, Validator validator) {
        this.fluent = this;
        this.withReplicas(instance.getReplicas());
        this.withSelector(instance.getSelector());
        this.withTargetSelector(instance.getTargetSelector());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ScaleStatus build() {
        ScaleStatus buildable = new ScaleStatus(this.fluent.getReplicas(), this.fluent.getSelector(), this.fluent.getTargetSelector());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScaleStatusBuilder that = (ScaleStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

