/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2.admissionregistration;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_2.admissionregistration.Webhook;
import io.fabric8.kubernetes.api.model.v4_2.admissionregistration.WebhookFluent;
import io.fabric8.kubernetes.api.model.v4_2.admissionregistration.WebhookFluentImpl;
import javax.validation.Validator;

public class WebhookBuilder
extends WebhookFluentImpl<WebhookBuilder>
implements VisitableBuilder<Webhook, WebhookBuilder> {
    WebhookFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public WebhookBuilder() {
        this(true);
    }

    public WebhookBuilder(Boolean validationEnabled) {
        this(new Webhook(), validationEnabled);
    }

    public WebhookBuilder(WebhookFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public WebhookBuilder(WebhookFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Webhook(), validationEnabled);
    }

    public WebhookBuilder(WebhookFluent<?> fluent, Webhook instance) {
        this(fluent, instance, true);
    }

    public WebhookBuilder(WebhookFluent<?> fluent, Webhook instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withClientConfig(instance.getClientConfig());
        fluent.withFailurePolicy(instance.getFailurePolicy());
        fluent.withName(instance.getName());
        fluent.withNamespaceSelector(instance.getNamespaceSelector());
        fluent.withRules(instance.getRules());
        fluent.withSideEffects(instance.getSideEffects());
        this.validationEnabled = validationEnabled;
    }

    public WebhookBuilder(Webhook instance) {
        this(instance, (Boolean)true);
    }

    public WebhookBuilder(Webhook instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withClientConfig(instance.getClientConfig());
        this.withFailurePolicy(instance.getFailurePolicy());
        this.withName(instance.getName());
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withRules(instance.getRules());
        this.withSideEffects(instance.getSideEffects());
        this.validationEnabled = validationEnabled;
    }

    public WebhookBuilder(Validator validator) {
        this(new Webhook(), (Boolean)true);
    }

    public WebhookBuilder(WebhookFluent<?> fluent, Webhook instance, Validator validator) {
        this.fluent = fluent;
        fluent.withClientConfig(instance.getClientConfig());
        fluent.withFailurePolicy(instance.getFailurePolicy());
        fluent.withName(instance.getName());
        fluent.withNamespaceSelector(instance.getNamespaceSelector());
        fluent.withRules(instance.getRules());
        fluent.withSideEffects(instance.getSideEffects());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public WebhookBuilder(Webhook instance, Validator validator) {
        this.fluent = this;
        this.withClientConfig(instance.getClientConfig());
        this.withFailurePolicy(instance.getFailurePolicy());
        this.withName(instance.getName());
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withRules(instance.getRules());
        this.withSideEffects(instance.getSideEffects());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Webhook build() {
        Webhook buildable = new Webhook(this.fluent.getClientConfig(), this.fluent.getFailurePolicy(), this.fluent.getName(), this.fluent.getNamespaceSelector(), this.fluent.getRules(), this.fluent.getSideEffects());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebhookBuilder that = (WebhookBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

