/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_2.ObjectMetricSource;
import io.fabric8.kubernetes.api.model.v4_2.ObjectMetricSourceFluent;
import io.fabric8.kubernetes.api.model.v4_2.ObjectMetricSourceFluentImpl;
import javax.validation.Validator;

public class ObjectMetricSourceBuilder
extends ObjectMetricSourceFluentImpl<ObjectMetricSourceBuilder>
implements VisitableBuilder<ObjectMetricSource, ObjectMetricSourceBuilder> {
    ObjectMetricSourceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ObjectMetricSourceBuilder() {
        this(true);
    }

    public ObjectMetricSourceBuilder(Boolean validationEnabled) {
        this(new ObjectMetricSource(), validationEnabled);
    }

    public ObjectMetricSourceBuilder(ObjectMetricSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ObjectMetricSourceBuilder(ObjectMetricSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ObjectMetricSource(), validationEnabled);
    }

    public ObjectMetricSourceBuilder(ObjectMetricSourceFluent<?> fluent, ObjectMetricSource instance) {
        this(fluent, instance, true);
    }

    public ObjectMetricSourceBuilder(ObjectMetricSourceFluent<?> fluent, ObjectMetricSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAverageValue(instance.getAverageValue());
        fluent.withMetricName(instance.getMetricName());
        fluent.withSelector(instance.getSelector());
        fluent.withTarget(instance.getTarget());
        fluent.withTargetValue(instance.getTargetValue());
        this.validationEnabled = validationEnabled;
    }

    public ObjectMetricSourceBuilder(ObjectMetricSource instance) {
        this(instance, (Boolean)true);
    }

    public ObjectMetricSourceBuilder(ObjectMetricSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAverageValue(instance.getAverageValue());
        this.withMetricName(instance.getMetricName());
        this.withSelector(instance.getSelector());
        this.withTarget(instance.getTarget());
        this.withTargetValue(instance.getTargetValue());
        this.validationEnabled = validationEnabled;
    }

    public ObjectMetricSourceBuilder(Validator validator) {
        this(new ObjectMetricSource(), (Boolean)true);
    }

    public ObjectMetricSourceBuilder(ObjectMetricSourceFluent<?> fluent, ObjectMetricSource instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAverageValue(instance.getAverageValue());
        fluent.withMetricName(instance.getMetricName());
        fluent.withSelector(instance.getSelector());
        fluent.withTarget(instance.getTarget());
        fluent.withTargetValue(instance.getTargetValue());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ObjectMetricSourceBuilder(ObjectMetricSource instance, Validator validator) {
        this.fluent = this;
        this.withAverageValue(instance.getAverageValue());
        this.withMetricName(instance.getMetricName());
        this.withSelector(instance.getSelector());
        this.withTarget(instance.getTarget());
        this.withTargetValue(instance.getTargetValue());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ObjectMetricSource build() {
        ObjectMetricSource buildable = new ObjectMetricSource(this.fluent.getAverageValue(), this.fluent.getMetricName(), this.fluent.getSelector(), this.fluent.getTarget(), this.fluent.getTargetValue());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectMetricSourceBuilder that = (ObjectMetricSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

