/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_2.ExternalMetricStatus;
import io.fabric8.kubernetes.api.model.v4_2.ExternalMetricStatusFluent;
import io.fabric8.kubernetes.api.model.v4_2.ExternalMetricStatusFluentImpl;
import javax.validation.Validator;

public class ExternalMetricStatusBuilder
extends ExternalMetricStatusFluentImpl<ExternalMetricStatusBuilder>
implements VisitableBuilder<ExternalMetricStatus, ExternalMetricStatusBuilder> {
    ExternalMetricStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ExternalMetricStatusBuilder() {
        this(true);
    }

    public ExternalMetricStatusBuilder(Boolean validationEnabled) {
        this(new ExternalMetricStatus(), validationEnabled);
    }

    public ExternalMetricStatusBuilder(ExternalMetricStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ExternalMetricStatusBuilder(ExternalMetricStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ExternalMetricStatus(), validationEnabled);
    }

    public ExternalMetricStatusBuilder(ExternalMetricStatusFluent<?> fluent, ExternalMetricStatus instance) {
        this(fluent, instance, true);
    }

    public ExternalMetricStatusBuilder(ExternalMetricStatusFluent<?> fluent, ExternalMetricStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCurrentAverageValue(instance.getCurrentAverageValue());
        fluent.withCurrentValue(instance.getCurrentValue());
        fluent.withMetricName(instance.getMetricName());
        fluent.withMetricSelector(instance.getMetricSelector());
        this.validationEnabled = validationEnabled;
    }

    public ExternalMetricStatusBuilder(ExternalMetricStatus instance) {
        this(instance, (Boolean)true);
    }

    public ExternalMetricStatusBuilder(ExternalMetricStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCurrentAverageValue(instance.getCurrentAverageValue());
        this.withCurrentValue(instance.getCurrentValue());
        this.withMetricName(instance.getMetricName());
        this.withMetricSelector(instance.getMetricSelector());
        this.validationEnabled = validationEnabled;
    }

    public ExternalMetricStatusBuilder(Validator validator) {
        this(new ExternalMetricStatus(), (Boolean)true);
    }

    public ExternalMetricStatusBuilder(ExternalMetricStatusFluent<?> fluent, ExternalMetricStatus instance, Validator validator) {
        this.fluent = fluent;
        fluent.withCurrentAverageValue(instance.getCurrentAverageValue());
        fluent.withCurrentValue(instance.getCurrentValue());
        fluent.withMetricName(instance.getMetricName());
        fluent.withMetricSelector(instance.getMetricSelector());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ExternalMetricStatusBuilder(ExternalMetricStatus instance, Validator validator) {
        this.fluent = this;
        this.withCurrentAverageValue(instance.getCurrentAverageValue());
        this.withCurrentValue(instance.getCurrentValue());
        this.withMetricName(instance.getMetricName());
        this.withMetricSelector(instance.getMetricSelector());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ExternalMetricStatus build() {
        ExternalMetricStatus buildable = new ExternalMetricStatus(this.fluent.getCurrentAverageValue(), this.fluent.getCurrentValue(), this.fluent.getMetricName(), this.fluent.getMetricSelector());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalMetricStatusBuilder that = (ExternalMetricStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

