/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_2.ComponentCondition;
import io.fabric8.kubernetes.api.model.v4_2.ComponentConditionFluent;
import io.fabric8.kubernetes.api.model.v4_2.ComponentConditionFluentImpl;
import javax.validation.Validator;

public class ComponentConditionBuilder
extends ComponentConditionFluentImpl<ComponentConditionBuilder>
implements VisitableBuilder<ComponentCondition, ComponentConditionBuilder> {
    ComponentConditionFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ComponentConditionBuilder() {
        this(true);
    }

    public ComponentConditionBuilder(Boolean validationEnabled) {
        this(new ComponentCondition(), validationEnabled);
    }

    public ComponentConditionBuilder(ComponentConditionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ComponentConditionBuilder(ComponentConditionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ComponentCondition(), validationEnabled);
    }

    public ComponentConditionBuilder(ComponentConditionFluent<?> fluent, ComponentCondition instance) {
        this(fluent, instance, true);
    }

    public ComponentConditionBuilder(ComponentConditionFluent<?> fluent, ComponentCondition instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withError(instance.getError());
        fluent.withMessage(instance.getMessage());
        fluent.withStatus(instance.getStatus());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public ComponentConditionBuilder(ComponentCondition instance) {
        this(instance, (Boolean)true);
    }

    public ComponentConditionBuilder(ComponentCondition instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withError(instance.getError());
        this.withMessage(instance.getMessage());
        this.withStatus(instance.getStatus());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public ComponentConditionBuilder(Validator validator) {
        this(new ComponentCondition(), (Boolean)true);
    }

    public ComponentConditionBuilder(ComponentConditionFluent<?> fluent, ComponentCondition instance, Validator validator) {
        this.fluent = fluent;
        fluent.withError(instance.getError());
        fluent.withMessage(instance.getMessage());
        fluent.withStatus(instance.getStatus());
        fluent.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ComponentConditionBuilder(ComponentCondition instance, Validator validator) {
        this.fluent = this;
        this.withError(instance.getError());
        this.withMessage(instance.getMessage());
        this.withStatus(instance.getStatus());
        this.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ComponentCondition build() {
        ComponentCondition buildable = new ComponentCondition(this.fluent.getError(), this.fluent.getMessage(), this.fluent.getStatus(), this.fluent.getType());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentConditionBuilder that = (ComponentConditionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

