/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_2;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_2.ClientIPConfig;
import io.fabric8.kubernetes.api.model.v4_2.ClientIPConfigFluent;
import io.fabric8.kubernetes.api.model.v4_2.ClientIPConfigFluentImpl;
import javax.validation.Validator;

public class ClientIPConfigBuilder
extends ClientIPConfigFluentImpl<ClientIPConfigBuilder>
implements VisitableBuilder<ClientIPConfig, ClientIPConfigBuilder> {
    ClientIPConfigFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ClientIPConfigBuilder() {
        this(true);
    }

    public ClientIPConfigBuilder(Boolean validationEnabled) {
        this(new ClientIPConfig(), validationEnabled);
    }

    public ClientIPConfigBuilder(ClientIPConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ClientIPConfigBuilder(ClientIPConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClientIPConfig(), validationEnabled);
    }

    public ClientIPConfigBuilder(ClientIPConfigFluent<?> fluent, ClientIPConfig instance) {
        this(fluent, instance, true);
    }

    public ClientIPConfigBuilder(ClientIPConfigFluent<?> fluent, ClientIPConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.validationEnabled = validationEnabled;
    }

    public ClientIPConfigBuilder(ClientIPConfig instance) {
        this(instance, (Boolean)true);
    }

    public ClientIPConfigBuilder(ClientIPConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.validationEnabled = validationEnabled;
    }

    public ClientIPConfigBuilder(Validator validator) {
        this(new ClientIPConfig(), (Boolean)true);
    }

    public ClientIPConfigBuilder(ClientIPConfigFluent<?> fluent, ClientIPConfig instance, Validator validator) {
        this.fluent = fluent;
        fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ClientIPConfigBuilder(ClientIPConfig instance, Validator validator) {
        this.fluent = this;
        this.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ClientIPConfig build() {
        ClientIPConfig buildable = new ClientIPConfig(this.fluent.getTimeoutSeconds());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientIPConfigBuilder that = (ClientIPConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

