/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.Scheduler;
import io.fabric8.openshift.api.model.SchedulerBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.SchedulerOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class SchedulerHandler
implements ResourceHandler<Scheduler, SchedulerBuilder> {
    @Override
    public String getKind() {
        return Scheduler.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "config.openshift.io/v1";
    }

    @Override
    public Scheduler create(OkHttpClient client, Config config, String namespace, Scheduler item) {
        return (Scheduler)new SchedulerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new Scheduler[0]);
    }

    @Override
    public Scheduler replace(OkHttpClient client, Config config, String namespace, Scheduler item) {
        return (Scheduler)((Resource)new SchedulerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Scheduler reload(OkHttpClient client, Config config, String namespace, Scheduler item) {
        return (Scheduler)((Gettable)((Resource)new SchedulerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public SchedulerBuilder edit(Scheduler item) {
        return new SchedulerBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Scheduler item) {
        return (Boolean)new SchedulerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Scheduler item, Watcher<Scheduler> watcher) {
        return (Watch)((Resource)new SchedulerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Scheduler item, String resourceVersion, Watcher<Scheduler> watcher) {
        return (Watch)((Resource)new SchedulerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Scheduler item, ListOptions options, Watcher<Scheduler> watcher) {
        return (Watch)((Resource)new SchedulerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Scheduler waitUntilReady(OkHttpClient client, Config config, String namespace, Scheduler item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Scheduler)((Resource)new SchedulerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Scheduler waitUntilCondition(OkHttpClient client, Config config, String namespace, Scheduler item, Predicate<Scheduler> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Scheduler)((Resource)new SchedulerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

