/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.GoogleIdentityProvider;
import io.fabric8.openshift.api.model.GoogleIdentityProviderFluent;
import io.fabric8.openshift.api.model.GoogleIdentityProviderFluentImpl;
import java.util.Objects;

public class GoogleIdentityProviderBuilder
extends GoogleIdentityProviderFluentImpl<GoogleIdentityProviderBuilder>
implements VisitableBuilder<GoogleIdentityProvider, GoogleIdentityProviderBuilder> {
    GoogleIdentityProviderFluent<?> fluent;
    Boolean validationEnabled;

    public GoogleIdentityProviderBuilder() {
        this(true);
    }

    public GoogleIdentityProviderBuilder(Boolean validationEnabled) {
        this(new GoogleIdentityProvider(), validationEnabled);
    }

    public GoogleIdentityProviderBuilder(GoogleIdentityProviderFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public GoogleIdentityProviderBuilder(GoogleIdentityProviderFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new GoogleIdentityProvider(), validationEnabled);
    }

    public GoogleIdentityProviderBuilder(GoogleIdentityProviderFluent<?> fluent, GoogleIdentityProvider instance) {
        this(fluent, instance, true);
    }

    public GoogleIdentityProviderBuilder(GoogleIdentityProviderFluent<?> fluent, GoogleIdentityProvider instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withClientID(instance.getClientID());
        fluent.withClientSecret(instance.getClientSecret());
        fluent.withHostedDomain(instance.getHostedDomain());
        this.validationEnabled = validationEnabled;
    }

    public GoogleIdentityProviderBuilder(GoogleIdentityProvider instance) {
        this(instance, (Boolean)true);
    }

    public GoogleIdentityProviderBuilder(GoogleIdentityProvider instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withClientID(instance.getClientID());
        this.withClientSecret(instance.getClientSecret());
        this.withHostedDomain(instance.getHostedDomain());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public GoogleIdentityProvider build() {
        GoogleIdentityProvider buildable = new GoogleIdentityProvider(this.fluent.getClientID(), this.fluent.getClientSecret(), this.fluent.getHostedDomain());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GoogleIdentityProviderBuilder that = (GoogleIdentityProviderBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

