/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_13.handlers;

import io.fabric8.kubernetes.api.model.v4_13.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_13.ListOptions;
import io.fabric8.kubernetes.clnt.v4_13.Config;
import io.fabric8.kubernetes.clnt.v4_13.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_13.Watch;
import io.fabric8.kubernetes.clnt.v4_13.Watcher;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Resource;
import io.fabric8.openshift.api.model.v4_13.ClusterVersion;
import io.fabric8.openshift.api.model.v4_13.ClusterVersionBuilder;
import io.fabric8.openshift.clnt.v4_13.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_13.dsl.internal.ClusterVersionOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ClusterVersionHandler
implements ResourceHandler<ClusterVersion, ClusterVersionBuilder> {
    @Override
    public String getKind() {
        return ClusterVersion.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "config.openshift.io/v1";
    }

    @Override
    public ClusterVersion create(OkHttpClient client, Config config, String namespace, ClusterVersion item) {
        return (ClusterVersion)new ClusterVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new ClusterVersion[0]);
    }

    @Override
    public ClusterVersion replace(OkHttpClient client, Config config, String namespace, ClusterVersion item) {
        return (ClusterVersion)((Resource)new ClusterVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public ClusterVersion reload(OkHttpClient client, Config config, String namespace, ClusterVersion item) {
        return (ClusterVersion)((Gettable)((Resource)new ClusterVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ClusterVersionBuilder edit(ClusterVersion item) {
        return new ClusterVersionBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ClusterVersion item) {
        return (Boolean)new ClusterVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterVersion item, Watcher<ClusterVersion> watcher) {
        return (Watch)((Resource)new ClusterVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterVersion item, String resourceVersion, Watcher<ClusterVersion> watcher) {
        return (Watch)((Resource)new ClusterVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ClusterVersion item, ListOptions options, Watcher<ClusterVersion> watcher) {
        return (Watch)((Resource)new ClusterVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public ClusterVersion waitUntilReady(OkHttpClient client, Config config, String namespace, ClusterVersion item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ClusterVersion)((Resource)new ClusterVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public ClusterVersion waitUntilCondition(OkHttpClient client, Config config, String namespace, ClusterVersion item, Predicate<ClusterVersion> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ClusterVersion)((Resource)new ClusterVersionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

