/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_13;

import io.fabric8.kubernetes.api.builder.v4_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_13.Nested;
import io.fabric8.kubernetes.api.builder.v4_13.Predicate;
import io.fabric8.kubernetes.api.model.v4_13.ObjectMeta;
import io.fabric8.kubernetes.api.model.v4_13.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v4_13.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.v4_13.Image;
import io.fabric8.openshift.api.model.v4_13.ImageFluent;
import io.fabric8.openshift.api.model.v4_13.ImageLayer;
import io.fabric8.openshift.api.model.v4_13.ImageLayerBuilder;
import io.fabric8.openshift.api.model.v4_13.ImageLayerFluentImpl;
import io.fabric8.openshift.api.model.v4_13.ImageSignature;
import io.fabric8.openshift.api.model.v4_13.ImageSignatureBuilder;
import io.fabric8.openshift.api.model.v4_13.ImageSignatureFluentImpl;
import io.fabric8.openshift.api.model.v4_13.runtime.RawExtension;
import io.fabric8.openshift.api.model.v4_13.runtime.RawExtensionBuilder;
import io.fabric8.openshift.api.model.v4_13.runtime.RawExtensionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ImageFluentImpl<A extends ImageFluent<A>>
extends BaseFluent<A>
implements ImageFluent<A> {
    private String apiVersion;
    private String dockerImageConfig;
    private List<ImageLayerBuilder> dockerImageLayers = new ArrayList<ImageLayerBuilder>();
    private String dockerImageManifest;
    private String dockerImageManifestMediaType;
    private RawExtensionBuilder dockerImageMetadata;
    private String dockerImageMetadataVersion;
    private String dockerImageReference;
    private List<String> dockerImageSignatures = new ArrayList<String>();
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<ImageSignatureBuilder> signatures = new ArrayList<ImageSignatureBuilder>();

    public ImageFluentImpl() {
    }

    public ImageFluentImpl(Image instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withDockerImageConfig(instance.getDockerImageConfig());
        this.withDockerImageLayers(instance.getDockerImageLayers());
        this.withDockerImageManifest(instance.getDockerImageManifest());
        this.withDockerImageManifestMediaType(instance.getDockerImageManifestMediaType());
        this.withDockerImageMetadata(instance.getDockerImageMetadata());
        this.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion());
        this.withDockerImageReference(instance.getDockerImageReference());
        this.withDockerImageSignatures(instance.getDockerImageSignatures());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSignatures(instance.getSignatures());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getDockerImageConfig() {
        return this.dockerImageConfig;
    }

    @Override
    public A withDockerImageConfig(String dockerImageConfig) {
        this.dockerImageConfig = dockerImageConfig;
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageConfig() {
        return this.dockerImageConfig != null;
    }

    @Override
    public A withNewDockerImageConfig(String arg1) {
        return this.withDockerImageConfig(new String(arg1));
    }

    @Override
    public A withNewDockerImageConfig(StringBuilder arg1) {
        return this.withDockerImageConfig(new String(arg1));
    }

    @Override
    public A withNewDockerImageConfig(StringBuffer arg1) {
        return this.withDockerImageConfig(new String(arg1));
    }

    @Override
    public A addToDockerImageLayers(int index, ImageLayer item) {
        if (this.dockerImageLayers == null) {
            this.dockerImageLayers = new ArrayList<ImageLayerBuilder>();
        }
        ImageLayerBuilder builder = new ImageLayerBuilder(item);
        this._visitables.get("dockerImageLayers").add(index >= 0 ? index : this._visitables.get("dockerImageLayers").size(), builder);
        this.dockerImageLayers.add(index >= 0 ? index : this.dockerImageLayers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToDockerImageLayers(int index, ImageLayer item) {
        if (this.dockerImageLayers == null) {
            this.dockerImageLayers = new ArrayList<ImageLayerBuilder>();
        }
        ImageLayerBuilder builder = new ImageLayerBuilder(item);
        if (index < 0 || index >= this._visitables.get("dockerImageLayers").size()) {
            this._visitables.get("dockerImageLayers").add(builder);
        } else {
            this._visitables.get("dockerImageLayers").set(index, builder);
        }
        if (index < 0 || index >= this.dockerImageLayers.size()) {
            this.dockerImageLayers.add(builder);
        } else {
            this.dockerImageLayers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToDockerImageLayers(ImageLayer ... items) {
        if (this.dockerImageLayers == null) {
            this.dockerImageLayers = new ArrayList<ImageLayerBuilder>();
        }
        for (ImageLayer item : items) {
            ImageLayerBuilder builder = new ImageLayerBuilder(item);
            this._visitables.get("dockerImageLayers").add(builder);
            this.dockerImageLayers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToDockerImageLayers(Collection<ImageLayer> items) {
        if (this.dockerImageLayers == null) {
            this.dockerImageLayers = new ArrayList<ImageLayerBuilder>();
        }
        for (ImageLayer item : items) {
            ImageLayerBuilder builder = new ImageLayerBuilder(item);
            this._visitables.get("dockerImageLayers").add(builder);
            this.dockerImageLayers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromDockerImageLayers(ImageLayer ... items) {
        for (ImageLayer item : items) {
            ImageLayerBuilder builder = new ImageLayerBuilder(item);
            this._visitables.get("dockerImageLayers").remove(builder);
            if (this.dockerImageLayers == null) continue;
            this.dockerImageLayers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDockerImageLayers(Collection<ImageLayer> items) {
        for (ImageLayer item : items) {
            ImageLayerBuilder builder = new ImageLayerBuilder(item);
            this._visitables.get("dockerImageLayers").remove(builder);
            if (this.dockerImageLayers == null) continue;
            this.dockerImageLayers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromDockerImageLayers(Predicate<ImageLayerBuilder> predicate) {
        if (this.dockerImageLayers == null) {
            return (A)this;
        }
        Iterator<ImageLayerBuilder> each = this.dockerImageLayers.iterator();
        Object visitables = this._visitables.get("dockerImageLayers");
        while (each.hasNext()) {
            ImageLayerBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageLayer> getDockerImageLayers() {
        return ImageFluentImpl.build(this.dockerImageLayers);
    }

    @Override
    public List<ImageLayer> buildDockerImageLayers() {
        return ImageFluentImpl.build(this.dockerImageLayers);
    }

    @Override
    public ImageLayer buildDockerImageLayer(int index) {
        return this.dockerImageLayers.get(index).build();
    }

    @Override
    public ImageLayer buildFirstDockerImageLayer() {
        return this.dockerImageLayers.get(0).build();
    }

    @Override
    public ImageLayer buildLastDockerImageLayer() {
        return this.dockerImageLayers.get(this.dockerImageLayers.size() - 1).build();
    }

    @Override
    public ImageLayer buildMatchingDockerImageLayer(Predicate<ImageLayerBuilder> predicate) {
        for (ImageLayerBuilder item : this.dockerImageLayers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDockerImageLayer(Predicate<ImageLayerBuilder> predicate) {
        for (ImageLayerBuilder item : this.dockerImageLayers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDockerImageLayers(List<ImageLayer> dockerImageLayers) {
        if (this.dockerImageLayers != null) {
            this._visitables.get("dockerImageLayers").removeAll(this.dockerImageLayers);
        }
        if (dockerImageLayers != null) {
            this.dockerImageLayers = new ArrayList<ImageLayerBuilder>();
            for (ImageLayer item : dockerImageLayers) {
                this.addToDockerImageLayers(item);
            }
        } else {
            this.dockerImageLayers = null;
        }
        return (A)this;
    }

    @Override
    public A withDockerImageLayers(ImageLayer ... dockerImageLayers) {
        if (this.dockerImageLayers != null) {
            this.dockerImageLayers.clear();
        }
        if (dockerImageLayers != null) {
            for (ImageLayer item : dockerImageLayers) {
                this.addToDockerImageLayers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageLayers() {
        return this.dockerImageLayers != null && !this.dockerImageLayers.isEmpty();
    }

    @Override
    public A addNewDockerImageLayer(String mediaType, String name, Long size) {
        return this.addToDockerImageLayers(new ImageLayer(mediaType, name, size));
    }

    @Override
    public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayer() {
        return new DockerImageLayersNestedImpl();
    }

    @Override
    public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayerLike(ImageLayer item) {
        return new DockerImageLayersNestedImpl(-1, item);
    }

    @Override
    public ImageFluent.DockerImageLayersNested<A> setNewDockerImageLayerLike(int index, ImageLayer item) {
        return new DockerImageLayersNestedImpl(index, item);
    }

    @Override
    public ImageFluent.DockerImageLayersNested<A> editDockerImageLayer(int index) {
        if (this.dockerImageLayers.size() <= index) {
            throw new RuntimeException("Can't edit dockerImageLayers. Index exceeds size.");
        }
        return this.setNewDockerImageLayerLike(index, this.buildDockerImageLayer(index));
    }

    @Override
    public ImageFluent.DockerImageLayersNested<A> editFirstDockerImageLayer() {
        if (this.dockerImageLayers.size() == 0) {
            throw new RuntimeException("Can't edit first dockerImageLayers. The list is empty.");
        }
        return this.setNewDockerImageLayerLike(0, this.buildDockerImageLayer(0));
    }

    @Override
    public ImageFluent.DockerImageLayersNested<A> editLastDockerImageLayer() {
        int index = this.dockerImageLayers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dockerImageLayers. The list is empty.");
        }
        return this.setNewDockerImageLayerLike(index, this.buildDockerImageLayer(index));
    }

    @Override
    public ImageFluent.DockerImageLayersNested<A> editMatchingDockerImageLayer(Predicate<ImageLayerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dockerImageLayers.size(); ++i) {
            if (!predicate.apply(this.dockerImageLayers.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dockerImageLayers. No match found.");
        }
        return this.setNewDockerImageLayerLike(index, this.buildDockerImageLayer(index));
    }

    @Override
    public String getDockerImageManifest() {
        return this.dockerImageManifest;
    }

    @Override
    public A withDockerImageManifest(String dockerImageManifest) {
        this.dockerImageManifest = dockerImageManifest;
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageManifest() {
        return this.dockerImageManifest != null;
    }

    @Override
    public A withNewDockerImageManifest(String arg1) {
        return this.withDockerImageManifest(new String(arg1));
    }

    @Override
    public A withNewDockerImageManifest(StringBuilder arg1) {
        return this.withDockerImageManifest(new String(arg1));
    }

    @Override
    public A withNewDockerImageManifest(StringBuffer arg1) {
        return this.withDockerImageManifest(new String(arg1));
    }

    @Override
    public String getDockerImageManifestMediaType() {
        return this.dockerImageManifestMediaType;
    }

    @Override
    public A withDockerImageManifestMediaType(String dockerImageManifestMediaType) {
        this.dockerImageManifestMediaType = dockerImageManifestMediaType;
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageManifestMediaType() {
        return this.dockerImageManifestMediaType != null;
    }

    @Override
    public A withNewDockerImageManifestMediaType(String arg1) {
        return this.withDockerImageManifestMediaType(new String(arg1));
    }

    @Override
    public A withNewDockerImageManifestMediaType(StringBuilder arg1) {
        return this.withDockerImageManifestMediaType(new String(arg1));
    }

    @Override
    public A withNewDockerImageManifestMediaType(StringBuffer arg1) {
        return this.withDockerImageManifestMediaType(new String(arg1));
    }

    @Override
    @Deprecated
    public RawExtension getDockerImageMetadata() {
        return this.dockerImageMetadata != null ? this.dockerImageMetadata.build() : null;
    }

    @Override
    public RawExtension buildDockerImageMetadata() {
        return this.dockerImageMetadata != null ? this.dockerImageMetadata.build() : null;
    }

    @Override
    public A withDockerImageMetadata(RawExtension dockerImageMetadata) {
        this._visitables.get("dockerImageMetadata").remove(this.dockerImageMetadata);
        if (dockerImageMetadata != null) {
            this.dockerImageMetadata = new RawExtensionBuilder(dockerImageMetadata);
            this._visitables.get("dockerImageMetadata").add(this.dockerImageMetadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageMetadata() {
        return this.dockerImageMetadata != null;
    }

    @Override
    public ImageFluent.DockerImageMetadataNested<A> withNewDockerImageMetadata() {
        return new DockerImageMetadataNestedImpl();
    }

    @Override
    public ImageFluent.DockerImageMetadataNested<A> withNewDockerImageMetadataLike(RawExtension item) {
        return new DockerImageMetadataNestedImpl(item);
    }

    @Override
    public ImageFluent.DockerImageMetadataNested<A> editDockerImageMetadata() {
        return this.withNewDockerImageMetadataLike(this.getDockerImageMetadata());
    }

    @Override
    public ImageFluent.DockerImageMetadataNested<A> editOrNewDockerImageMetadata() {
        return this.withNewDockerImageMetadataLike(this.getDockerImageMetadata() != null ? this.getDockerImageMetadata() : new RawExtensionBuilder().build());
    }

    @Override
    public ImageFluent.DockerImageMetadataNested<A> editOrNewDockerImageMetadataLike(RawExtension item) {
        return this.withNewDockerImageMetadataLike(this.getDockerImageMetadata() != null ? this.getDockerImageMetadata() : item);
    }

    @Override
    public String getDockerImageMetadataVersion() {
        return this.dockerImageMetadataVersion;
    }

    @Override
    public A withDockerImageMetadataVersion(String dockerImageMetadataVersion) {
        this.dockerImageMetadataVersion = dockerImageMetadataVersion;
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageMetadataVersion() {
        return this.dockerImageMetadataVersion != null;
    }

    @Override
    public A withNewDockerImageMetadataVersion(String arg1) {
        return this.withDockerImageMetadataVersion(new String(arg1));
    }

    @Override
    public A withNewDockerImageMetadataVersion(StringBuilder arg1) {
        return this.withDockerImageMetadataVersion(new String(arg1));
    }

    @Override
    public A withNewDockerImageMetadataVersion(StringBuffer arg1) {
        return this.withDockerImageMetadataVersion(new String(arg1));
    }

    @Override
    public String getDockerImageReference() {
        return this.dockerImageReference;
    }

    @Override
    public A withDockerImageReference(String dockerImageReference) {
        this.dockerImageReference = dockerImageReference;
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageReference() {
        return this.dockerImageReference != null;
    }

    @Override
    public A withNewDockerImageReference(String arg1) {
        return this.withDockerImageReference(new String(arg1));
    }

    @Override
    public A withNewDockerImageReference(StringBuilder arg1) {
        return this.withDockerImageReference(new String(arg1));
    }

    @Override
    public A withNewDockerImageReference(StringBuffer arg1) {
        return this.withDockerImageReference(new String(arg1));
    }

    @Override
    public A addToDockerImageSignatures(int index, String item) {
        if (this.dockerImageSignatures == null) {
            this.dockerImageSignatures = new ArrayList<String>();
        }
        this.dockerImageSignatures.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDockerImageSignatures(int index, String item) {
        if (this.dockerImageSignatures == null) {
            this.dockerImageSignatures = new ArrayList<String>();
        }
        this.dockerImageSignatures.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDockerImageSignatures(String ... items) {
        if (this.dockerImageSignatures == null) {
            this.dockerImageSignatures = new ArrayList<String>();
        }
        for (String item : items) {
            this.dockerImageSignatures.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDockerImageSignatures(Collection<String> items) {
        if (this.dockerImageSignatures == null) {
            this.dockerImageSignatures = new ArrayList<String>();
        }
        for (String item : items) {
            this.dockerImageSignatures.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDockerImageSignatures(String ... items) {
        for (String item : items) {
            if (this.dockerImageSignatures == null) continue;
            this.dockerImageSignatures.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDockerImageSignatures(Collection<String> items) {
        for (String item : items) {
            if (this.dockerImageSignatures == null) continue;
            this.dockerImageSignatures.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDockerImageSignatures() {
        return this.dockerImageSignatures;
    }

    @Override
    public String getDockerImageSignature(int index) {
        return this.dockerImageSignatures.get(index);
    }

    @Override
    public String getFirstDockerImageSignature() {
        return this.dockerImageSignatures.get(0);
    }

    @Override
    public String getLastDockerImageSignature() {
        return this.dockerImageSignatures.get(this.dockerImageSignatures.size() - 1);
    }

    @Override
    public String getMatchingDockerImageSignature(Predicate<String> predicate) {
        for (String item : this.dockerImageSignatures) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDockerImageSignature(Predicate<String> predicate) {
        for (String item : this.dockerImageSignatures) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDockerImageSignatures(List<String> dockerImageSignatures) {
        if (this.dockerImageSignatures != null) {
            this._visitables.get("dockerImageSignatures").removeAll(this.dockerImageSignatures);
        }
        if (dockerImageSignatures != null) {
            this.dockerImageSignatures = new ArrayList<String>();
            for (String item : dockerImageSignatures) {
                this.addToDockerImageSignatures(item);
            }
        } else {
            this.dockerImageSignatures = null;
        }
        return (A)this;
    }

    @Override
    public A withDockerImageSignatures(String ... dockerImageSignatures) {
        if (this.dockerImageSignatures != null) {
            this.dockerImageSignatures.clear();
        }
        if (dockerImageSignatures != null) {
            for (String item : dockerImageSignatures) {
                this.addToDockerImageSignatures(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageSignatures() {
        return this.dockerImageSignatures != null && !this.dockerImageSignatures.isEmpty();
    }

    @Override
    public A addNewDockerImageSignature(String arg1) {
        return this.addToDockerImageSignatures(new String(arg1));
    }

    @Override
    public A addNewDockerImageSignature(StringBuilder arg1) {
        return this.addToDockerImageSignatures(new String(arg1));
    }

    @Override
    public A addNewDockerImageSignature(StringBuffer arg1) {
        return this.addToDockerImageSignatures(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ImageFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ImageFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ImageFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ImageFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ImageFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToSignatures(int index, ImageSignature item) {
        if (this.signatures == null) {
            this.signatures = new ArrayList<ImageSignatureBuilder>();
        }
        ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
        this._visitables.get("signatures").add(index >= 0 ? index : this._visitables.get("signatures").size(), builder);
        this.signatures.add(index >= 0 ? index : this.signatures.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSignatures(int index, ImageSignature item) {
        if (this.signatures == null) {
            this.signatures = new ArrayList<ImageSignatureBuilder>();
        }
        ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
        if (index < 0 || index >= this._visitables.get("signatures").size()) {
            this._visitables.get("signatures").add(builder);
        } else {
            this._visitables.get("signatures").set(index, builder);
        }
        if (index < 0 || index >= this.signatures.size()) {
            this.signatures.add(builder);
        } else {
            this.signatures.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSignatures(ImageSignature ... items) {
        if (this.signatures == null) {
            this.signatures = new ArrayList<ImageSignatureBuilder>();
        }
        for (ImageSignature item : items) {
            ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
            this._visitables.get("signatures").add(builder);
            this.signatures.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSignatures(Collection<ImageSignature> items) {
        if (this.signatures == null) {
            this.signatures = new ArrayList<ImageSignatureBuilder>();
        }
        for (ImageSignature item : items) {
            ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
            this._visitables.get("signatures").add(builder);
            this.signatures.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSignatures(ImageSignature ... items) {
        for (ImageSignature item : items) {
            ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
            this._visitables.get("signatures").remove(builder);
            if (this.signatures == null) continue;
            this.signatures.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSignatures(Collection<ImageSignature> items) {
        for (ImageSignature item : items) {
            ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
            this._visitables.get("signatures").remove(builder);
            if (this.signatures == null) continue;
            this.signatures.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSignatures(Predicate<ImageSignatureBuilder> predicate) {
        if (this.signatures == null) {
            return (A)this;
        }
        Iterator<ImageSignatureBuilder> each = this.signatures.iterator();
        Object visitables = this._visitables.get("signatures");
        while (each.hasNext()) {
            ImageSignatureBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageSignature> getSignatures() {
        return ImageFluentImpl.build(this.signatures);
    }

    @Override
    public List<ImageSignature> buildSignatures() {
        return ImageFluentImpl.build(this.signatures);
    }

    @Override
    public ImageSignature buildSignature(int index) {
        return this.signatures.get(index).build();
    }

    @Override
    public ImageSignature buildFirstSignature() {
        return this.signatures.get(0).build();
    }

    @Override
    public ImageSignature buildLastSignature() {
        return this.signatures.get(this.signatures.size() - 1).build();
    }

    @Override
    public ImageSignature buildMatchingSignature(Predicate<ImageSignatureBuilder> predicate) {
        for (ImageSignatureBuilder item : this.signatures) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSignature(Predicate<ImageSignatureBuilder> predicate) {
        for (ImageSignatureBuilder item : this.signatures) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSignatures(List<ImageSignature> signatures) {
        if (this.signatures != null) {
            this._visitables.get("signatures").removeAll(this.signatures);
        }
        if (signatures != null) {
            this.signatures = new ArrayList<ImageSignatureBuilder>();
            for (ImageSignature item : signatures) {
                this.addToSignatures(item);
            }
        } else {
            this.signatures = null;
        }
        return (A)this;
    }

    @Override
    public A withSignatures(ImageSignature ... signatures) {
        if (this.signatures != null) {
            this.signatures.clear();
        }
        if (signatures != null) {
            for (ImageSignature item : signatures) {
                this.addToSignatures(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSignatures() {
        return this.signatures != null && !this.signatures.isEmpty();
    }

    @Override
    public ImageFluent.SignaturesNested<A> addNewSignature() {
        return new SignaturesNestedImpl();
    }

    @Override
    public ImageFluent.SignaturesNested<A> addNewSignatureLike(ImageSignature item) {
        return new SignaturesNestedImpl(-1, item);
    }

    @Override
    public ImageFluent.SignaturesNested<A> setNewSignatureLike(int index, ImageSignature item) {
        return new SignaturesNestedImpl(index, item);
    }

    @Override
    public ImageFluent.SignaturesNested<A> editSignature(int index) {
        if (this.signatures.size() <= index) {
            throw new RuntimeException("Can't edit signatures. Index exceeds size.");
        }
        return this.setNewSignatureLike(index, this.buildSignature(index));
    }

    @Override
    public ImageFluent.SignaturesNested<A> editFirstSignature() {
        if (this.signatures.size() == 0) {
            throw new RuntimeException("Can't edit first signatures. The list is empty.");
        }
        return this.setNewSignatureLike(0, this.buildSignature(0));
    }

    @Override
    public ImageFluent.SignaturesNested<A> editLastSignature() {
        int index = this.signatures.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last signatures. The list is empty.");
        }
        return this.setNewSignatureLike(index, this.buildSignature(index));
    }

    @Override
    public ImageFluent.SignaturesNested<A> editMatchingSignature(Predicate<ImageSignatureBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.signatures.size(); ++i) {
            if (!predicate.apply(this.signatures.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching signatures. No match found.");
        }
        return this.setNewSignatureLike(index, this.buildSignature(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageFluentImpl that = (ImageFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.dockerImageConfig != null ? !this.dockerImageConfig.equals(that.dockerImageConfig) : that.dockerImageConfig != null) {
            return false;
        }
        if (this.dockerImageLayers != null ? !this.dockerImageLayers.equals(that.dockerImageLayers) : that.dockerImageLayers != null) {
            return false;
        }
        if (this.dockerImageManifest != null ? !this.dockerImageManifest.equals(that.dockerImageManifest) : that.dockerImageManifest != null) {
            return false;
        }
        if (this.dockerImageManifestMediaType != null ? !this.dockerImageManifestMediaType.equals(that.dockerImageManifestMediaType) : that.dockerImageManifestMediaType != null) {
            return false;
        }
        if (this.dockerImageMetadata != null ? !this.dockerImageMetadata.equals(that.dockerImageMetadata) : that.dockerImageMetadata != null) {
            return false;
        }
        if (this.dockerImageMetadataVersion != null ? !this.dockerImageMetadataVersion.equals(that.dockerImageMetadataVersion) : that.dockerImageMetadataVersion != null) {
            return false;
        }
        if (this.dockerImageReference != null ? !this.dockerImageReference.equals(that.dockerImageReference) : that.dockerImageReference != null) {
            return false;
        }
        if (this.dockerImageSignatures != null ? !this.dockerImageSignatures.equals(that.dockerImageSignatures) : that.dockerImageSignatures != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.signatures != null ? !this.signatures.equals(that.signatures) : that.signatures != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.dockerImageConfig, this.dockerImageLayers, this.dockerImageManifest, this.dockerImageManifestMediaType, this.dockerImageMetadata, this.dockerImageMetadataVersion, this.dockerImageReference, this.dockerImageSignatures, this.kind, this.metadata, this.signatures, super.hashCode());
    }

    public class SignaturesNestedImpl<N>
    extends ImageSignatureFluentImpl<ImageFluent.SignaturesNested<N>>
    implements ImageFluent.SignaturesNested<N>,
    Nested<N> {
        private final ImageSignatureBuilder builder;
        private final int index;

        SignaturesNestedImpl(int index, ImageSignature item) {
            this.index = index;
            this.builder = new ImageSignatureBuilder(this, item);
        }

        SignaturesNestedImpl() {
            this.index = -1;
            this.builder = new ImageSignatureBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageFluentImpl.this.setToSignatures(this.index, this.builder.build());
        }

        @Override
        public N endSignature() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ImageFluent.MetadataNested<N>>
    implements ImageFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class DockerImageMetadataNestedImpl<N>
    extends RawExtensionFluentImpl<ImageFluent.DockerImageMetadataNested<N>>
    implements ImageFluent.DockerImageMetadataNested<N>,
    Nested<N> {
        private final RawExtensionBuilder builder;

        DockerImageMetadataNestedImpl(RawExtension item) {
            this.builder = new RawExtensionBuilder(this, item);
        }

        DockerImageMetadataNestedImpl() {
            this.builder = new RawExtensionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageFluentImpl.this.withDockerImageMetadata(this.builder.build());
        }

        @Override
        public N endDockerImageMetadata() {
            return this.and();
        }
    }

    public class DockerImageLayersNestedImpl<N>
    extends ImageLayerFluentImpl<ImageFluent.DockerImageLayersNested<N>>
    implements ImageFluent.DockerImageLayersNested<N>,
    Nested<N> {
        private final ImageLayerBuilder builder;
        private final int index;

        DockerImageLayersNestedImpl(int index, ImageLayer item) {
            this.index = index;
            this.builder = new ImageLayerBuilder(this, item);
        }

        DockerImageLayersNestedImpl() {
            this.index = -1;
            this.builder = new ImageLayerBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageFluentImpl.this.setToDockerImageLayers(this.index, this.builder.build());
        }

        @Override
        public N endDockerImageLayer() {
            return this.and();
        }
    }
}

