/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_13;

import io.fabric8.kubernetes.api.builder.v4_13.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_13.Audit;
import io.fabric8.openshift.api.model.v4_13.AuditFluent;
import io.fabric8.openshift.api.model.v4_13.AuditFluentImpl;
import java.util.Objects;

public class AuditBuilder
extends AuditFluentImpl<AuditBuilder>
implements VisitableBuilder<Audit, AuditBuilder> {
    AuditFluent<?> fluent;
    Boolean validationEnabled;

    public AuditBuilder() {
        this(true);
    }

    public AuditBuilder(Boolean validationEnabled) {
        this(new Audit(), validationEnabled);
    }

    public AuditBuilder(AuditFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public AuditBuilder(AuditFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Audit(), validationEnabled);
    }

    public AuditBuilder(AuditFluent<?> fluent, Audit instance) {
        this(fluent, instance, true);
    }

    public AuditBuilder(AuditFluent<?> fluent, Audit instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withProfile(instance.getProfile());
        this.validationEnabled = validationEnabled;
    }

    public AuditBuilder(Audit instance) {
        this(instance, (Boolean)true);
    }

    public AuditBuilder(Audit instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withProfile(instance.getProfile());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Audit build() {
        Audit buildable = new Audit(this.fluent.getProfile());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuditBuilder that = (AuditBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

