/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_13.handlers.networking.v1;

import io.fabric8.kubernetes.api.model.v4_13.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_13.ListOptions;
import io.fabric8.kubernetes.api.model.v4_13.networking.v1.Ingress;
import io.fabric8.kubernetes.api.model.v4_13.networking.v1.IngressBuilder;
import io.fabric8.kubernetes.clnt.v4_13.Config;
import io.fabric8.kubernetes.clnt.v4_13.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_13.Watch;
import io.fabric8.kubernetes.clnt.v4_13.Watcher;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_13.dsl.internal.networking.v1.IngressOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class IngressHandler
implements ResourceHandler<Ingress, IngressBuilder> {
    @Override
    public String getKind() {
        return Ingress.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "networking.k8s.io/v1";
    }

    @Override
    public Ingress create(OkHttpClient client, Config config, String namespace, Ingress item) {
        return (Ingress)new IngressOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new Ingress[0]);
    }

    @Override
    public Ingress replace(OkHttpClient client, Config config, String namespace, Ingress item) {
        return (Ingress)((Resource)new IngressOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Ingress reload(OkHttpClient client, Config config, String namespace, Ingress item) {
        return (Ingress)((Gettable)((Resource)new IngressOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public IngressBuilder edit(Ingress item) {
        return new IngressBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Ingress item) {
        return (Boolean)new IngressOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Ingress item, Watcher<Ingress> watcher) {
        return (Watch)((Resource)new IngressOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Ingress item, String resourceVersion, Watcher<Ingress> watcher) {
        return (Watch)((Resource)new IngressOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Ingress item, ListOptions options, Watcher<Ingress> watcher) {
        return (Watch)((Resource)new IngressOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Ingress waitUntilReady(OkHttpClient client, Config config, String namespace, Ingress item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Ingress)((Resource)new IngressOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Ingress waitUntilCondition(OkHttpClient client, Config config, String namespace, Ingress item, Predicate<Ingress> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Ingress)((Resource)new IngressOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

