/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_13.dsl.internal;

import io.fabric8.kubernetes.clnt.v4_13.Config;
import io.fabric8.kubernetes.clnt.v4_13.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Createable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_13.dsl.base.OperationSupport;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import okhttp3.OkHttpClient;

public class CreateOnlyResourceOperationsImpl<T, D>
extends OperationSupport
implements Createable<T, T, D> {
    private final Class<T> subjectAccessRequestClass;

    public CreateOnlyResourceOperationsImpl(OkHttpClient client, Config config, String apiGroupName, String apiGroupVersion, String plural, Class<T> subjectAccessRequestClass) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config), apiGroupName, apiGroupVersion, plural, subjectAccessRequestClass);
    }

    public CreateOnlyResourceOperationsImpl(OperationContext context, String apiGroupName, String apiGroupVersion, String plural, Class<T> subjectAccessRequestClass) {
        super(context.withApiGroupName(apiGroupName).withApiGroupVersion(apiGroupVersion).withPlural(plural));
        this.subjectAccessRequestClass = subjectAccessRequestClass;
    }

    @Override
    public boolean isResourceNamespaced() {
        return false;
    }

    @Override
    public T create(T ... resources) {
        try {
            if (resources.length > 1) {
                throw new IllegalArgumentException("Too many items to create.");
            }
            if (resources.length == 1) {
                return this.handleCreate(resources[0], this.subjectAccessRequestClass);
            }
            return this.handleCreate(this.getItem(), this.subjectAccessRequestClass);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(ie);
        }
    }

    @Override
    public T create(T item) {
        try {
            return this.handleCreate(item, this.subjectAccessRequestClass);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(ie);
        }
    }

    @Override
    public D createNew() {
        throw new IllegalStateException("this operation is not supported, please use create() instead");
    }

    public T getItem() {
        return (T)this.context.getItem();
    }
}

