/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_13.networking.v1;

import io.fabric8.kubernetes.api.builder.v4_13.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_13.networking.v1.IngressRule;
import io.fabric8.kubernetes.api.model.v4_13.networking.v1.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.v4_13.networking.v1.IngressRuleFluentImpl;
import java.util.Objects;

public class IngressRuleBuilder
extends IngressRuleFluentImpl<IngressRuleBuilder>
implements VisitableBuilder<IngressRule, IngressRuleBuilder> {
    IngressRuleFluent<?> fluent;
    Boolean validationEnabled;

    public IngressRuleBuilder() {
        this(true);
    }

    public IngressRuleBuilder(Boolean validationEnabled) {
        this(new IngressRule(), validationEnabled);
    }

    public IngressRuleBuilder(IngressRuleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public IngressRuleBuilder(IngressRuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IngressRule(), validationEnabled);
    }

    public IngressRuleBuilder(IngressRuleFluent<?> fluent, IngressRule instance) {
        this(fluent, instance, true);
    }

    public IngressRuleBuilder(IngressRuleFluent<?> fluent, IngressRule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHost(instance.getHost());
        fluent.withHttp(instance.getHttp());
        this.validationEnabled = validationEnabled;
    }

    public IngressRuleBuilder(IngressRule instance) {
        this(instance, (Boolean)true);
    }

    public IngressRuleBuilder(IngressRule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHost(instance.getHost());
        this.withHttp(instance.getHttp());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public IngressRule build() {
        IngressRule buildable = new IngressRule(this.fluent.getHost(), this.fluent.getHttp());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressRuleBuilder that = (IngressRuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

