/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_13.apps;

import io.fabric8.kubernetes.api.builder.v4_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_13.Nested;
import io.fabric8.kubernetes.api.builder.v4_13.Predicate;
import io.fabric8.kubernetes.api.model.v4_13.LabelSelector;
import io.fabric8.kubernetes.api.model.v4_13.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v4_13.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.v4_13.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v4_13.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.v4_13.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.v4_13.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.v4_13.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.v4_13.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.v4_13.apps.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.v4_13.apps.StatefulSetSpecFluent;
import io.fabric8.kubernetes.api.model.v4_13.apps.StatefulSetUpdateStrategy;
import io.fabric8.kubernetes.api.model.v4_13.apps.StatefulSetUpdateStrategyBuilder;
import io.fabric8.kubernetes.api.model.v4_13.apps.StatefulSetUpdateStrategyFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class StatefulSetSpecFluentImpl<A extends StatefulSetSpecFluent<A>>
extends BaseFluent<A>
implements StatefulSetSpecFluent<A> {
    private String podManagementPolicy;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private LabelSelectorBuilder selector;
    private String serviceName;
    private PodTemplateSpecBuilder template;
    private StatefulSetUpdateStrategyBuilder updateStrategy;
    private List<PersistentVolumeClaimBuilder> volumeClaimTemplates = new ArrayList<PersistentVolumeClaimBuilder>();

    public StatefulSetSpecFluentImpl() {
    }

    public StatefulSetSpecFluentImpl(StatefulSetSpec instance) {
        this.withPodManagementPolicy(instance.getPodManagementPolicy());
        this.withReplicas(instance.getReplicas());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withSelector(instance.getSelector());
        this.withServiceName(instance.getServiceName());
        this.withTemplate(instance.getTemplate());
        this.withUpdateStrategy(instance.getUpdateStrategy());
        this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
    }

    @Override
    public String getPodManagementPolicy() {
        return this.podManagementPolicy;
    }

    @Override
    public A withPodManagementPolicy(String podManagementPolicy) {
        this.podManagementPolicy = podManagementPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasPodManagementPolicy() {
        return this.podManagementPolicy != null;
    }

    @Override
    public A withNewPodManagementPolicy(String arg1) {
        return this.withPodManagementPolicy(new String(arg1));
    }

    @Override
    public A withNewPodManagementPolicy(StringBuilder arg1) {
        return this.withPodManagementPolicy(new String(arg1));
    }

    @Override
    public A withNewPodManagementPolicy(StringBuffer arg1) {
        return this.withPodManagementPolicy(new String(arg1));
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    @Override
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public StatefulSetSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public StatefulSetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public StatefulSetSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public StatefulSetSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public StatefulSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public A withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceName() {
        return this.serviceName != null;
    }

    @Override
    public A withNewServiceName(String arg1) {
        return this.withServiceName(new String(arg1));
    }

    @Override
    public A withNewServiceName(StringBuilder arg1) {
        return this.withServiceName(new String(arg1));
    }

    @Override
    public A withNewServiceName(StringBuffer arg1) {
        return this.withServiceName(new String(arg1));
    }

    @Override
    @Deprecated
    public PodTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(PodTemplateSpec template) {
        this._visitables.get("template").remove(this.template);
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public StatefulSetSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public StatefulSetSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public StatefulSetSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new PodTemplateSpecBuilder().build());
    }

    @Override
    public StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    @Deprecated
    public StatefulSetUpdateStrategy getUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    @Override
    public StatefulSetUpdateStrategy buildUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    @Override
    public A withUpdateStrategy(StatefulSetUpdateStrategy updateStrategy) {
        this._visitables.get("updateStrategy").remove(this.updateStrategy);
        if (updateStrategy != null) {
            this.updateStrategy = new StatefulSetUpdateStrategyBuilder(updateStrategy);
            this._visitables.get("updateStrategy").add(this.updateStrategy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUpdateStrategy() {
        return this.updateStrategy != null;
    }

    @Override
    public StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy() {
        return new UpdateStrategyNestedImpl();
    }

    @Override
    public StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(StatefulSetUpdateStrategy item) {
        return new UpdateStrategyNestedImpl(item);
    }

    @Override
    public StatefulSetSpecFluent.UpdateStrategyNested<A> editUpdateStrategy() {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy());
    }

    @Override
    public StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy() {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy() != null ? this.getUpdateStrategy() : new StatefulSetUpdateStrategyBuilder().build());
    }

    @Override
    public StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(StatefulSetUpdateStrategy item) {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy() != null ? this.getUpdateStrategy() : item);
    }

    @Override
    public A addToVolumeClaimTemplates(int index, PersistentVolumeClaim item) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList<PersistentVolumeClaimBuilder>();
        }
        PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
        this._visitables.get("volumeClaimTemplates").add(index >= 0 ? index : this._visitables.get("volumeClaimTemplates").size(), builder);
        this.volumeClaimTemplates.add(index >= 0 ? index : this.volumeClaimTemplates.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumeClaimTemplates(int index, PersistentVolumeClaim item) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList<PersistentVolumeClaimBuilder>();
        }
        PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
        if (index < 0 || index >= this._visitables.get("volumeClaimTemplates").size()) {
            this._visitables.get("volumeClaimTemplates").add(builder);
        } else {
            this._visitables.get("volumeClaimTemplates").set(index, builder);
        }
        if (index < 0 || index >= this.volumeClaimTemplates.size()) {
            this.volumeClaimTemplates.add(builder);
        } else {
            this.volumeClaimTemplates.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumeClaimTemplates(PersistentVolumeClaim ... items) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList<PersistentVolumeClaimBuilder>();
        }
        for (PersistentVolumeClaim item : items) {
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
            this._visitables.get("volumeClaimTemplates").add(builder);
            this.volumeClaimTemplates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumeClaimTemplates(Collection<PersistentVolumeClaim> items) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList<PersistentVolumeClaimBuilder>();
        }
        for (PersistentVolumeClaim item : items) {
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
            this._visitables.get("volumeClaimTemplates").add(builder);
            this.volumeClaimTemplates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeClaimTemplates(PersistentVolumeClaim ... items) {
        for (PersistentVolumeClaim item : items) {
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
            this._visitables.get("volumeClaimTemplates").remove(builder);
            if (this.volumeClaimTemplates == null) continue;
            this.volumeClaimTemplates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumeClaimTemplates(Collection<PersistentVolumeClaim> items) {
        for (PersistentVolumeClaim item : items) {
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
            this._visitables.get("volumeClaimTemplates").remove(builder);
            if (this.volumeClaimTemplates == null) continue;
            this.volumeClaimTemplates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVolumeClaimTemplates(Predicate<PersistentVolumeClaimBuilder> predicate) {
        if (this.volumeClaimTemplates == null) {
            return (A)this;
        }
        Iterator<PersistentVolumeClaimBuilder> each = this.volumeClaimTemplates.iterator();
        Object visitables = this._visitables.get("volumeClaimTemplates");
        while (each.hasNext()) {
            PersistentVolumeClaimBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PersistentVolumeClaim> getVolumeClaimTemplates() {
        return StatefulSetSpecFluentImpl.build(this.volumeClaimTemplates);
    }

    @Override
    public List<PersistentVolumeClaim> buildVolumeClaimTemplates() {
        return StatefulSetSpecFluentImpl.build(this.volumeClaimTemplates);
    }

    @Override
    public PersistentVolumeClaim buildVolumeClaimTemplate(int index) {
        return this.volumeClaimTemplates.get(index).build();
    }

    @Override
    public PersistentVolumeClaim buildFirstVolumeClaimTemplate() {
        return this.volumeClaimTemplates.get(0).build();
    }

    @Override
    public PersistentVolumeClaim buildLastVolumeClaimTemplate() {
        return this.volumeClaimTemplates.get(this.volumeClaimTemplates.size() - 1).build();
    }

    @Override
    public PersistentVolumeClaim buildMatchingVolumeClaimTemplate(Predicate<PersistentVolumeClaimBuilder> predicate) {
        for (PersistentVolumeClaimBuilder item : this.volumeClaimTemplates) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolumeClaimTemplate(Predicate<PersistentVolumeClaimBuilder> predicate) {
        for (PersistentVolumeClaimBuilder item : this.volumeClaimTemplates) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumeClaimTemplates(List<PersistentVolumeClaim> volumeClaimTemplates) {
        if (this.volumeClaimTemplates != null) {
            this._visitables.get("volumeClaimTemplates").removeAll(this.volumeClaimTemplates);
        }
        if (volumeClaimTemplates != null) {
            this.volumeClaimTemplates = new ArrayList<PersistentVolumeClaimBuilder>();
            for (PersistentVolumeClaim item : volumeClaimTemplates) {
                this.addToVolumeClaimTemplates(item);
            }
        } else {
            this.volumeClaimTemplates = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumeClaimTemplates(PersistentVolumeClaim ... volumeClaimTemplates) {
        if (this.volumeClaimTemplates != null) {
            this.volumeClaimTemplates.clear();
        }
        if (volumeClaimTemplates != null) {
            for (PersistentVolumeClaim item : volumeClaimTemplates) {
                this.addToVolumeClaimTemplates(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeClaimTemplates() {
        return this.volumeClaimTemplates != null && !this.volumeClaimTemplates.isEmpty();
    }

    @Override
    public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplate() {
        return new VolumeClaimTemplatesNestedImpl();
    }

    @Override
    public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplateLike(PersistentVolumeClaim item) {
        return new VolumeClaimTemplatesNestedImpl(-1, item);
    }

    @Override
    public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> setNewVolumeClaimTemplateLike(int index, PersistentVolumeClaim item) {
        return new VolumeClaimTemplatesNestedImpl(index, item);
    }

    @Override
    public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editVolumeClaimTemplate(int index) {
        if (this.volumeClaimTemplates.size() <= index) {
            throw new RuntimeException("Can't edit volumeClaimTemplates. Index exceeds size.");
        }
        return this.setNewVolumeClaimTemplateLike(index, this.buildVolumeClaimTemplate(index));
    }

    @Override
    public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editFirstVolumeClaimTemplate() {
        if (this.volumeClaimTemplates.size() == 0) {
            throw new RuntimeException("Can't edit first volumeClaimTemplates. The list is empty.");
        }
        return this.setNewVolumeClaimTemplateLike(0, this.buildVolumeClaimTemplate(0));
    }

    @Override
    public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editLastVolumeClaimTemplate() {
        int index = this.volumeClaimTemplates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeClaimTemplates. The list is empty.");
        }
        return this.setNewVolumeClaimTemplateLike(index, this.buildVolumeClaimTemplate(index));
    }

    @Override
    public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editMatchingVolumeClaimTemplate(Predicate<PersistentVolumeClaimBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeClaimTemplates.size(); ++i) {
            if (!predicate.apply(this.volumeClaimTemplates.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeClaimTemplates. No match found.");
        }
        return this.setNewVolumeClaimTemplateLike(index, this.buildVolumeClaimTemplate(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatefulSetSpecFluentImpl that = (StatefulSetSpecFluentImpl)o;
        if (this.podManagementPolicy != null ? !this.podManagementPolicy.equals(that.podManagementPolicy) : that.podManagementPolicy != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.revisionHistoryLimit != null ? !this.revisionHistoryLimit.equals(that.revisionHistoryLimit) : that.revisionHistoryLimit != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        if (this.updateStrategy != null ? !this.updateStrategy.equals(that.updateStrategy) : that.updateStrategy != null) {
            return false;
        }
        return !(this.volumeClaimTemplates != null ? !this.volumeClaimTemplates.equals(that.volumeClaimTemplates) : that.volumeClaimTemplates != null);
    }

    public int hashCode() {
        return Objects.hash(this.podManagementPolicy, this.replicas, this.revisionHistoryLimit, this.selector, this.serviceName, this.template, this.updateStrategy, this.volumeClaimTemplates, super.hashCode());
    }

    public class VolumeClaimTemplatesNestedImpl<N>
    extends PersistentVolumeClaimFluentImpl<StatefulSetSpecFluent.VolumeClaimTemplatesNested<N>>
    implements StatefulSetSpecFluent.VolumeClaimTemplatesNested<N>,
    Nested<N> {
        private final PersistentVolumeClaimBuilder builder;
        private final int index;

        VolumeClaimTemplatesNestedImpl(int index, PersistentVolumeClaim item) {
            this.index = index;
            this.builder = new PersistentVolumeClaimBuilder(this, item);
        }

        VolumeClaimTemplatesNestedImpl() {
            this.index = -1;
            this.builder = new PersistentVolumeClaimBuilder(this);
        }

        @Override
        public N and() {
            return (N)StatefulSetSpecFluentImpl.this.setToVolumeClaimTemplates(this.index, this.builder.build());
        }

        @Override
        public N endVolumeClaimTemplate() {
            return this.and();
        }
    }

    public class UpdateStrategyNestedImpl<N>
    extends StatefulSetUpdateStrategyFluentImpl<StatefulSetSpecFluent.UpdateStrategyNested<N>>
    implements StatefulSetSpecFluent.UpdateStrategyNested<N>,
    Nested<N> {
        private final StatefulSetUpdateStrategyBuilder builder;

        UpdateStrategyNestedImpl(StatefulSetUpdateStrategy item) {
            this.builder = new StatefulSetUpdateStrategyBuilder(this, item);
        }

        UpdateStrategyNestedImpl() {
            this.builder = new StatefulSetUpdateStrategyBuilder(this);
        }

        @Override
        public N and() {
            return (N)StatefulSetSpecFluentImpl.this.withUpdateStrategy(this.builder.build());
        }

        @Override
        public N endUpdateStrategy() {
            return this.and();
        }
    }

    public class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<StatefulSetSpecFluent.TemplateNested<N>>
    implements StatefulSetSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final PodTemplateSpecBuilder builder;

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)StatefulSetSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<StatefulSetSpecFluent.SelectorNested<N>>
    implements StatefulSetSpecFluent.SelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)StatefulSetSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

