/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_13;

import io.fabric8.kubernetes.api.builder.v4_13.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_13.Nested;
import io.fabric8.kubernetes.api.builder.v4_13.Predicate;
import io.fabric8.kubernetes.api.model.v4_13.ContainerStatus;
import io.fabric8.kubernetes.api.model.v4_13.ContainerStatusBuilder;
import io.fabric8.kubernetes.api.model.v4_13.ContainerStatusFluentImpl;
import io.fabric8.kubernetes.api.model.v4_13.PodCondition;
import io.fabric8.kubernetes.api.model.v4_13.PodConditionBuilder;
import io.fabric8.kubernetes.api.model.v4_13.PodConditionFluentImpl;
import io.fabric8.kubernetes.api.model.v4_13.PodIP;
import io.fabric8.kubernetes.api.model.v4_13.PodIPBuilder;
import io.fabric8.kubernetes.api.model.v4_13.PodIPFluentImpl;
import io.fabric8.kubernetes.api.model.v4_13.PodStatus;
import io.fabric8.kubernetes.api.model.v4_13.PodStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class PodStatusFluentImpl<A extends PodStatusFluent<A>>
extends BaseFluent<A>
implements PodStatusFluent<A> {
    private List<PodConditionBuilder> conditions = new ArrayList<PodConditionBuilder>();
    private List<ContainerStatusBuilder> containerStatuses = new ArrayList<ContainerStatusBuilder>();
    private List<ContainerStatusBuilder> ephemeralContainerStatuses = new ArrayList<ContainerStatusBuilder>();
    private String hostIP;
    private List<ContainerStatusBuilder> initContainerStatuses = new ArrayList<ContainerStatusBuilder>();
    private String message;
    private String nominatedNodeName;
    private String phase;
    private String podIP;
    private List<PodIPBuilder> podIPs = new ArrayList<PodIPBuilder>();
    private String qosClass;
    private String reason;
    private String startTime;

    public PodStatusFluentImpl() {
    }

    public PodStatusFluentImpl(PodStatus instance) {
        this.withConditions(instance.getConditions());
        this.withContainerStatuses(instance.getContainerStatuses());
        this.withEphemeralContainerStatuses(instance.getEphemeralContainerStatuses());
        this.withHostIP(instance.getHostIP());
        this.withInitContainerStatuses(instance.getInitContainerStatuses());
        this.withMessage(instance.getMessage());
        this.withNominatedNodeName(instance.getNominatedNodeName());
        this.withPhase(instance.getPhase());
        this.withPodIP(instance.getPodIP());
        this.withPodIPs(instance.getPodIPs());
        this.withQosClass(instance.getQosClass());
        this.withReason(instance.getReason());
        this.withStartTime(instance.getStartTime());
    }

    @Override
    public A addToConditions(int index, PodCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<PodConditionBuilder>();
        }
        PodConditionBuilder builder = new PodConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, PodCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<PodConditionBuilder>();
        }
        PodConditionBuilder builder = new PodConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(PodCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<PodConditionBuilder>();
        }
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<PodCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<PodConditionBuilder>();
        }
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(PodCondition ... items) {
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<PodCondition> items) {
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<PodConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<PodConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            PodConditionBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PodCondition> getConditions() {
        return PodStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<PodCondition> buildConditions() {
        return PodStatusFluentImpl.build(this.conditions);
    }

    @Override
    public PodCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public PodCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public PodCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public PodCondition buildMatchingCondition(Predicate<PodConditionBuilder> predicate) {
        for (PodConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<PodConditionBuilder> predicate) {
        for (PodConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<PodCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<PodConditionBuilder>();
            for (PodCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(PodCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (PodCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public PodStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public PodStatusFluent.ConditionsNested<A> addNewConditionLike(PodCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public PodStatusFluent.ConditionsNested<A> setNewConditionLike(int index, PodCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public PodStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public PodStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public PodStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public PodStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<PodConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply(this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public A addToContainerStatuses(int index, ContainerStatus item) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList<ContainerStatusBuilder>();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        this._visitables.get("containerStatuses").add(index >= 0 ? index : this._visitables.get("containerStatuses").size(), builder);
        this.containerStatuses.add(index >= 0 ? index : this.containerStatuses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToContainerStatuses(int index, ContainerStatus item) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList<ContainerStatusBuilder>();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get("containerStatuses").size()) {
            this._visitables.get("containerStatuses").add(builder);
        } else {
            this._visitables.get("containerStatuses").set(index, builder);
        }
        if (index < 0 || index >= this.containerStatuses.size()) {
            this.containerStatuses.add(builder);
        } else {
            this.containerStatuses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToContainerStatuses(ContainerStatus ... items) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList<ContainerStatusBuilder>();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainerStatuses(Collection<ContainerStatus> items) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList<ContainerStatusBuilder>();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainerStatuses(ContainerStatus ... items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").remove(builder);
            if (this.containerStatuses == null) continue;
            this.containerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainerStatuses(Collection<ContainerStatus> items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").remove(builder);
            if (this.containerStatuses == null) continue;
            this.containerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
        if (this.containerStatuses == null) {
            return (A)this;
        }
        Iterator<ContainerStatusBuilder> each = this.containerStatuses.iterator();
        Object visitables = this._visitables.get("containerStatuses");
        while (each.hasNext()) {
            ContainerStatusBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ContainerStatus> getContainerStatuses() {
        return PodStatusFluentImpl.build(this.containerStatuses);
    }

    @Override
    public List<ContainerStatus> buildContainerStatuses() {
        return PodStatusFluentImpl.build(this.containerStatuses);
    }

    @Override
    public ContainerStatus buildContainerStatus(int index) {
        return this.containerStatuses.get(index).build();
    }

    @Override
    public ContainerStatus buildFirstContainerStatus() {
        return this.containerStatuses.get(0).build();
    }

    @Override
    public ContainerStatus buildLastContainerStatus() {
        return this.containerStatuses.get(this.containerStatuses.size() - 1).build();
    }

    @Override
    public ContainerStatus buildMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.containerStatuses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.containerStatuses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainerStatuses(List<ContainerStatus> containerStatuses) {
        if (this.containerStatuses != null) {
            this._visitables.get("containerStatuses").removeAll(this.containerStatuses);
        }
        if (containerStatuses != null) {
            this.containerStatuses = new ArrayList<ContainerStatusBuilder>();
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        } else {
            this.containerStatuses = null;
        }
        return (A)this;
    }

    @Override
    public A withContainerStatuses(ContainerStatus ... containerStatuses) {
        if (this.containerStatuses != null) {
            this.containerStatuses.clear();
        }
        if (containerStatuses != null) {
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainerStatuses() {
        return this.containerStatuses != null && !this.containerStatuses.isEmpty();
    }

    @Override
    public PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatus() {
        return new ContainerStatusesNestedImpl();
    }

    @Override
    public PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatus item) {
        return new ContainerStatusesNestedImpl(-1, item);
    }

    @Override
    public PodStatusFluent.ContainerStatusesNested<A> setNewContainerStatusLike(int index, ContainerStatus item) {
        return new ContainerStatusesNestedImpl(index, item);
    }

    @Override
    public PodStatusFluent.ContainerStatusesNested<A> editContainerStatus(int index) {
        if (this.containerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit containerStatuses. Index exceeds size.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    @Override
    public PodStatusFluent.ContainerStatusesNested<A> editFirstContainerStatus() {
        if (this.containerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(0, this.buildContainerStatus(0));
    }

    @Override
    public PodStatusFluent.ContainerStatusesNested<A> editLastContainerStatus() {
        int index = this.containerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    @Override
    public PodStatusFluent.ContainerStatusesNested<A> editMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containerStatuses.size(); ++i) {
            if (!predicate.apply(this.containerStatuses.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containerStatuses. No match found.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    @Override
    public A addToEphemeralContainerStatuses(int index, ContainerStatus item) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList<ContainerStatusBuilder>();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        this._visitables.get("ephemeralContainerStatuses").add(index >= 0 ? index : this._visitables.get("ephemeralContainerStatuses").size(), builder);
        this.ephemeralContainerStatuses.add(index >= 0 ? index : this.ephemeralContainerStatuses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEphemeralContainerStatuses(int index, ContainerStatus item) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList<ContainerStatusBuilder>();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get("ephemeralContainerStatuses").size()) {
            this._visitables.get("ephemeralContainerStatuses").add(builder);
        } else {
            this._visitables.get("ephemeralContainerStatuses").set(index, builder);
        }
        if (index < 0 || index >= this.ephemeralContainerStatuses.size()) {
            this.ephemeralContainerStatuses.add(builder);
        } else {
            this.ephemeralContainerStatuses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEphemeralContainerStatuses(ContainerStatus ... items) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList<ContainerStatusBuilder>();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").add(builder);
            this.ephemeralContainerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEphemeralContainerStatuses(Collection<ContainerStatus> items) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList<ContainerStatusBuilder>();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").add(builder);
            this.ephemeralContainerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEphemeralContainerStatuses(ContainerStatus ... items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").remove(builder);
            if (this.ephemeralContainerStatuses == null) continue;
            this.ephemeralContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEphemeralContainerStatuses(Collection<ContainerStatus> items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").remove(builder);
            if (this.ephemeralContainerStatuses == null) continue;
            this.ephemeralContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEphemeralContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
        if (this.ephemeralContainerStatuses == null) {
            return (A)this;
        }
        Iterator<ContainerStatusBuilder> each = this.ephemeralContainerStatuses.iterator();
        Object visitables = this._visitables.get("ephemeralContainerStatuses");
        while (each.hasNext()) {
            ContainerStatusBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ContainerStatus> getEphemeralContainerStatuses() {
        return PodStatusFluentImpl.build(this.ephemeralContainerStatuses);
    }

    @Override
    public List<ContainerStatus> buildEphemeralContainerStatuses() {
        return PodStatusFluentImpl.build(this.ephemeralContainerStatuses);
    }

    @Override
    public ContainerStatus buildEphemeralContainerStatus(int index) {
        return this.ephemeralContainerStatuses.get(index).build();
    }

    @Override
    public ContainerStatus buildFirstEphemeralContainerStatus() {
        return this.ephemeralContainerStatuses.get(0).build();
    }

    @Override
    public ContainerStatus buildLastEphemeralContainerStatus() {
        return this.ephemeralContainerStatuses.get(this.ephemeralContainerStatuses.size() - 1).build();
    }

    @Override
    public ContainerStatus buildMatchingEphemeralContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.ephemeralContainerStatuses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEphemeralContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.ephemeralContainerStatuses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEphemeralContainerStatuses(List<ContainerStatus> ephemeralContainerStatuses) {
        if (this.ephemeralContainerStatuses != null) {
            this._visitables.get("ephemeralContainerStatuses").removeAll(this.ephemeralContainerStatuses);
        }
        if (ephemeralContainerStatuses != null) {
            this.ephemeralContainerStatuses = new ArrayList<ContainerStatusBuilder>();
            for (ContainerStatus item : ephemeralContainerStatuses) {
                this.addToEphemeralContainerStatuses(item);
            }
        } else {
            this.ephemeralContainerStatuses = null;
        }
        return (A)this;
    }

    @Override
    public A withEphemeralContainerStatuses(ContainerStatus ... ephemeralContainerStatuses) {
        if (this.ephemeralContainerStatuses != null) {
            this.ephemeralContainerStatuses.clear();
        }
        if (ephemeralContainerStatuses != null) {
            for (ContainerStatus item : ephemeralContainerStatuses) {
                this.addToEphemeralContainerStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEphemeralContainerStatuses() {
        return this.ephemeralContainerStatuses != null && !this.ephemeralContainerStatuses.isEmpty();
    }

    @Override
    public PodStatusFluent.EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatus() {
        return new EphemeralContainerStatusesNestedImpl();
    }

    @Override
    public PodStatusFluent.EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatusLike(ContainerStatus item) {
        return new EphemeralContainerStatusesNestedImpl(-1, item);
    }

    @Override
    public PodStatusFluent.EphemeralContainerStatusesNested<A> setNewEphemeralContainerStatusLike(int index, ContainerStatus item) {
        return new EphemeralContainerStatusesNestedImpl(index, item);
    }

    @Override
    public PodStatusFluent.EphemeralContainerStatusesNested<A> editEphemeralContainerStatus(int index) {
        if (this.ephemeralContainerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit ephemeralContainerStatuses. Index exceeds size.");
        }
        return this.setNewEphemeralContainerStatusLike(index, this.buildEphemeralContainerStatus(index));
    }

    @Override
    public PodStatusFluent.EphemeralContainerStatusesNested<A> editFirstEphemeralContainerStatus() {
        if (this.ephemeralContainerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first ephemeralContainerStatuses. The list is empty.");
        }
        return this.setNewEphemeralContainerStatusLike(0, this.buildEphemeralContainerStatus(0));
    }

    @Override
    public PodStatusFluent.EphemeralContainerStatusesNested<A> editLastEphemeralContainerStatus() {
        int index = this.ephemeralContainerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ephemeralContainerStatuses. The list is empty.");
        }
        return this.setNewEphemeralContainerStatusLike(index, this.buildEphemeralContainerStatus(index));
    }

    @Override
    public PodStatusFluent.EphemeralContainerStatusesNested<A> editMatchingEphemeralContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ephemeralContainerStatuses.size(); ++i) {
            if (!predicate.apply(this.ephemeralContainerStatuses.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ephemeralContainerStatuses. No match found.");
        }
        return this.setNewEphemeralContainerStatusLike(index, this.buildEphemeralContainerStatus(index));
    }

    @Override
    public String getHostIP() {
        return this.hostIP;
    }

    @Override
    public A withHostIP(String hostIP) {
        this.hostIP = hostIP;
        return (A)this;
    }

    @Override
    public Boolean hasHostIP() {
        return this.hostIP != null;
    }

    @Override
    public A withNewHostIP(String arg1) {
        return this.withHostIP(new String(arg1));
    }

    @Override
    public A withNewHostIP(StringBuilder arg1) {
        return this.withHostIP(new String(arg1));
    }

    @Override
    public A withNewHostIP(StringBuffer arg1) {
        return this.withHostIP(new String(arg1));
    }

    @Override
    public A addToInitContainerStatuses(int index, ContainerStatus item) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList<ContainerStatusBuilder>();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        this._visitables.get("initContainerStatuses").add(index >= 0 ? index : this._visitables.get("initContainerStatuses").size(), builder);
        this.initContainerStatuses.add(index >= 0 ? index : this.initContainerStatuses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToInitContainerStatuses(int index, ContainerStatus item) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList<ContainerStatusBuilder>();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get("initContainerStatuses").size()) {
            this._visitables.get("initContainerStatuses").add(builder);
        } else {
            this._visitables.get("initContainerStatuses").set(index, builder);
        }
        if (index < 0 || index >= this.initContainerStatuses.size()) {
            this.initContainerStatuses.add(builder);
        } else {
            this.initContainerStatuses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInitContainerStatuses(ContainerStatus ... items) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList<ContainerStatusBuilder>();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInitContainerStatuses(Collection<ContainerStatus> items) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList<ContainerStatusBuilder>();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInitContainerStatuses(ContainerStatus ... items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").remove(builder);
            if (this.initContainerStatuses == null) continue;
            this.initContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInitContainerStatuses(Collection<ContainerStatus> items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").remove(builder);
            if (this.initContainerStatuses == null) continue;
            this.initContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromInitContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
        if (this.initContainerStatuses == null) {
            return (A)this;
        }
        Iterator<ContainerStatusBuilder> each = this.initContainerStatuses.iterator();
        Object visitables = this._visitables.get("initContainerStatuses");
        while (each.hasNext()) {
            ContainerStatusBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ContainerStatus> getInitContainerStatuses() {
        return PodStatusFluentImpl.build(this.initContainerStatuses);
    }

    @Override
    public List<ContainerStatus> buildInitContainerStatuses() {
        return PodStatusFluentImpl.build(this.initContainerStatuses);
    }

    @Override
    public ContainerStatus buildInitContainerStatus(int index) {
        return this.initContainerStatuses.get(index).build();
    }

    @Override
    public ContainerStatus buildFirstInitContainerStatus() {
        return this.initContainerStatuses.get(0).build();
    }

    @Override
    public ContainerStatus buildLastInitContainerStatus() {
        return this.initContainerStatuses.get(this.initContainerStatuses.size() - 1).build();
    }

    @Override
    public ContainerStatus buildMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.initContainerStatuses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.initContainerStatuses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withInitContainerStatuses(List<ContainerStatus> initContainerStatuses) {
        if (this.initContainerStatuses != null) {
            this._visitables.get("initContainerStatuses").removeAll(this.initContainerStatuses);
        }
        if (initContainerStatuses != null) {
            this.initContainerStatuses = new ArrayList<ContainerStatusBuilder>();
            for (ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        } else {
            this.initContainerStatuses = null;
        }
        return (A)this;
    }

    @Override
    public A withInitContainerStatuses(ContainerStatus ... initContainerStatuses) {
        if (this.initContainerStatuses != null) {
            this.initContainerStatuses.clear();
        }
        if (initContainerStatuses != null) {
            for (ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasInitContainerStatuses() {
        return this.initContainerStatuses != null && !this.initContainerStatuses.isEmpty();
    }

    @Override
    public PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatus() {
        return new InitContainerStatusesNestedImpl();
    }

    @Override
    public PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatusLike(ContainerStatus item) {
        return new InitContainerStatusesNestedImpl(-1, item);
    }

    @Override
    public PodStatusFluent.InitContainerStatusesNested<A> setNewInitContainerStatusLike(int index, ContainerStatus item) {
        return new InitContainerStatusesNestedImpl(index, item);
    }

    @Override
    public PodStatusFluent.InitContainerStatusesNested<A> editInitContainerStatus(int index) {
        if (this.initContainerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit initContainerStatuses. Index exceeds size.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    @Override
    public PodStatusFluent.InitContainerStatusesNested<A> editFirstInitContainerStatus() {
        if (this.initContainerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first initContainerStatuses. The list is empty.");
        }
        return this.setNewInitContainerStatusLike(0, this.buildInitContainerStatus(0));
    }

    @Override
    public PodStatusFluent.InitContainerStatusesNested<A> editLastInitContainerStatus() {
        int index = this.initContainerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainerStatuses. The list is empty.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    @Override
    public PodStatusFluent.InitContainerStatusesNested<A> editMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainerStatuses.size(); ++i) {
            if (!predicate.apply(this.initContainerStatuses.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainerStatuses. No match found.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    @Override
    public Boolean hasMessage() {
        return this.message != null;
    }

    @Override
    public A withNewMessage(String arg1) {
        return this.withMessage(new String(arg1));
    }

    @Override
    public A withNewMessage(StringBuilder arg1) {
        return this.withMessage(new String(arg1));
    }

    @Override
    public A withNewMessage(StringBuffer arg1) {
        return this.withMessage(new String(arg1));
    }

    @Override
    public String getNominatedNodeName() {
        return this.nominatedNodeName;
    }

    @Override
    public A withNominatedNodeName(String nominatedNodeName) {
        this.nominatedNodeName = nominatedNodeName;
        return (A)this;
    }

    @Override
    public Boolean hasNominatedNodeName() {
        return this.nominatedNodeName != null;
    }

    @Override
    public A withNewNominatedNodeName(String arg1) {
        return this.withNominatedNodeName(new String(arg1));
    }

    @Override
    public A withNewNominatedNodeName(StringBuilder arg1) {
        return this.withNominatedNodeName(new String(arg1));
    }

    @Override
    public A withNewNominatedNodeName(StringBuffer arg1) {
        return this.withNominatedNodeName(new String(arg1));
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    @Override
    public Boolean hasPhase() {
        return this.phase != null;
    }

    @Override
    public A withNewPhase(String arg1) {
        return this.withPhase(new String(arg1));
    }

    @Override
    public A withNewPhase(StringBuilder arg1) {
        return this.withPhase(new String(arg1));
    }

    @Override
    public A withNewPhase(StringBuffer arg1) {
        return this.withPhase(new String(arg1));
    }

    @Override
    public String getPodIP() {
        return this.podIP;
    }

    @Override
    public A withPodIP(String podIP) {
        this.podIP = podIP;
        return (A)this;
    }

    @Override
    public Boolean hasPodIP() {
        return this.podIP != null;
    }

    @Override
    public A withNewPodIP(String arg1) {
        return this.withPodIP(new String(arg1));
    }

    @Override
    public A withNewPodIP(StringBuilder arg1) {
        return this.withPodIP(new String(arg1));
    }

    @Override
    public A withNewPodIP(StringBuffer arg1) {
        return this.withPodIP(new String(arg1));
    }

    @Override
    public A addToPodIPs(int index, PodIP item) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList<PodIPBuilder>();
        }
        PodIPBuilder builder = new PodIPBuilder(item);
        this._visitables.get("podIPs").add(index >= 0 ? index : this._visitables.get("podIPs").size(), builder);
        this.podIPs.add(index >= 0 ? index : this.podIPs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPodIPs(int index, PodIP item) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList<PodIPBuilder>();
        }
        PodIPBuilder builder = new PodIPBuilder(item);
        if (index < 0 || index >= this._visitables.get("podIPs").size()) {
            this._visitables.get("podIPs").add(builder);
        } else {
            this._visitables.get("podIPs").set(index, builder);
        }
        if (index < 0 || index >= this.podIPs.size()) {
            this.podIPs.add(builder);
        } else {
            this.podIPs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPodIPs(PodIP ... items) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList<PodIPBuilder>();
        }
        for (PodIP item : items) {
            PodIPBuilder builder = new PodIPBuilder(item);
            this._visitables.get("podIPs").add(builder);
            this.podIPs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPodIPs(Collection<PodIP> items) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList<PodIPBuilder>();
        }
        for (PodIP item : items) {
            PodIPBuilder builder = new PodIPBuilder(item);
            this._visitables.get("podIPs").add(builder);
            this.podIPs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPodIPs(PodIP ... items) {
        for (PodIP item : items) {
            PodIPBuilder builder = new PodIPBuilder(item);
            this._visitables.get("podIPs").remove(builder);
            if (this.podIPs == null) continue;
            this.podIPs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPodIPs(Collection<PodIP> items) {
        for (PodIP item : items) {
            PodIPBuilder builder = new PodIPBuilder(item);
            this._visitables.get("podIPs").remove(builder);
            if (this.podIPs == null) continue;
            this.podIPs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPodIPs(Predicate<PodIPBuilder> predicate) {
        if (this.podIPs == null) {
            return (A)this;
        }
        Iterator<PodIPBuilder> each = this.podIPs.iterator();
        Object visitables = this._visitables.get("podIPs");
        while (each.hasNext()) {
            PodIPBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PodIP> getPodIPs() {
        return PodStatusFluentImpl.build(this.podIPs);
    }

    @Override
    public List<PodIP> buildPodIPs() {
        return PodStatusFluentImpl.build(this.podIPs);
    }

    @Override
    public PodIP buildPodIP(int index) {
        return this.podIPs.get(index).build();
    }

    @Override
    public PodIP buildFirstPodIP() {
        return this.podIPs.get(0).build();
    }

    @Override
    public PodIP buildLastPodIP() {
        return this.podIPs.get(this.podIPs.size() - 1).build();
    }

    @Override
    public PodIP buildMatchingPodIP(Predicate<PodIPBuilder> predicate) {
        for (PodIPBuilder item : this.podIPs) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPodIP(Predicate<PodIPBuilder> predicate) {
        for (PodIPBuilder item : this.podIPs) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPodIPs(List<PodIP> podIPs) {
        if (this.podIPs != null) {
            this._visitables.get("podIPs").removeAll(this.podIPs);
        }
        if (podIPs != null) {
            this.podIPs = new ArrayList<PodIPBuilder>();
            for (PodIP item : podIPs) {
                this.addToPodIPs(item);
            }
        } else {
            this.podIPs = null;
        }
        return (A)this;
    }

    @Override
    public A withPodIPs(PodIP ... podIPs) {
        if (this.podIPs != null) {
            this.podIPs.clear();
        }
        if (podIPs != null) {
            for (PodIP item : podIPs) {
                this.addToPodIPs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPodIPs() {
        return this.podIPs != null && !this.podIPs.isEmpty();
    }

    @Override
    public A addNewPodIP(String ip) {
        return this.addToPodIPs(new PodIP(ip));
    }

    @Override
    public PodStatusFluent.PodIPsNested<A> addNewPodIP() {
        return new PodIPsNestedImpl();
    }

    @Override
    public PodStatusFluent.PodIPsNested<A> addNewPodIPLike(PodIP item) {
        return new PodIPsNestedImpl(-1, item);
    }

    @Override
    public PodStatusFluent.PodIPsNested<A> setNewPodIPLike(int index, PodIP item) {
        return new PodIPsNestedImpl(index, item);
    }

    @Override
    public PodStatusFluent.PodIPsNested<A> editPodIP(int index) {
        if (this.podIPs.size() <= index) {
            throw new RuntimeException("Can't edit podIPs. Index exceeds size.");
        }
        return this.setNewPodIPLike(index, this.buildPodIP(index));
    }

    @Override
    public PodStatusFluent.PodIPsNested<A> editFirstPodIP() {
        if (this.podIPs.size() == 0) {
            throw new RuntimeException("Can't edit first podIPs. The list is empty.");
        }
        return this.setNewPodIPLike(0, this.buildPodIP(0));
    }

    @Override
    public PodStatusFluent.PodIPsNested<A> editLastPodIP() {
        int index = this.podIPs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last podIPs. The list is empty.");
        }
        return this.setNewPodIPLike(index, this.buildPodIP(index));
    }

    @Override
    public PodStatusFluent.PodIPsNested<A> editMatchingPodIP(Predicate<PodIPBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.podIPs.size(); ++i) {
            if (!predicate.apply(this.podIPs.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching podIPs. No match found.");
        }
        return this.setNewPodIPLike(index, this.buildPodIP(index));
    }

    @Override
    public String getQosClass() {
        return this.qosClass;
    }

    @Override
    public A withQosClass(String qosClass) {
        this.qosClass = qosClass;
        return (A)this;
    }

    @Override
    public Boolean hasQosClass() {
        return this.qosClass != null;
    }

    @Override
    public A withNewQosClass(String arg1) {
        return this.withQosClass(new String(arg1));
    }

    @Override
    public A withNewQosClass(StringBuilder arg1) {
        return this.withQosClass(new String(arg1));
    }

    @Override
    public A withNewQosClass(StringBuffer arg1) {
        return this.withQosClass(new String(arg1));
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    @Override
    public Boolean hasReason() {
        return this.reason != null;
    }

    @Override
    public A withNewReason(String arg1) {
        return this.withReason(new String(arg1));
    }

    @Override
    public A withNewReason(StringBuilder arg1) {
        return this.withReason(new String(arg1));
    }

    @Override
    public A withNewReason(StringBuffer arg1) {
        return this.withReason(new String(arg1));
    }

    @Override
    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public A withStartTime(String startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    @Override
    public Boolean hasStartTime() {
        return this.startTime != null;
    }

    @Override
    public A withNewStartTime(String arg1) {
        return this.withStartTime(new String(arg1));
    }

    @Override
    public A withNewStartTime(StringBuilder arg1) {
        return this.withStartTime(new String(arg1));
    }

    @Override
    public A withNewStartTime(StringBuffer arg1) {
        return this.withStartTime(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodStatusFluentImpl that = (PodStatusFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.containerStatuses != null ? !this.containerStatuses.equals(that.containerStatuses) : that.containerStatuses != null) {
            return false;
        }
        if (this.ephemeralContainerStatuses != null ? !this.ephemeralContainerStatuses.equals(that.ephemeralContainerStatuses) : that.ephemeralContainerStatuses != null) {
            return false;
        }
        if (this.hostIP != null ? !this.hostIP.equals(that.hostIP) : that.hostIP != null) {
            return false;
        }
        if (this.initContainerStatuses != null ? !this.initContainerStatuses.equals(that.initContainerStatuses) : that.initContainerStatuses != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.nominatedNodeName != null ? !this.nominatedNodeName.equals(that.nominatedNodeName) : that.nominatedNodeName != null) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        if (this.podIP != null ? !this.podIP.equals(that.podIP) : that.podIP != null) {
            return false;
        }
        if (this.podIPs != null ? !this.podIPs.equals(that.podIPs) : that.podIPs != null) {
            return false;
        }
        if (this.qosClass != null ? !this.qosClass.equals(that.qosClass) : that.qosClass != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        return !(this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.containerStatuses, this.ephemeralContainerStatuses, this.hostIP, this.initContainerStatuses, this.message, this.nominatedNodeName, this.phase, this.podIP, this.podIPs, this.qosClass, this.reason, this.startTime, super.hashCode());
    }

    public class PodIPsNestedImpl<N>
    extends PodIPFluentImpl<PodStatusFluent.PodIPsNested<N>>
    implements PodStatusFluent.PodIPsNested<N>,
    Nested<N> {
        private final PodIPBuilder builder;
        private final int index;

        PodIPsNestedImpl(int index, PodIP item) {
            this.index = index;
            this.builder = new PodIPBuilder(this, item);
        }

        PodIPsNestedImpl() {
            this.index = -1;
            this.builder = new PodIPBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodStatusFluentImpl.this.setToPodIPs(this.index, this.builder.build());
        }

        @Override
        public N endPodIP() {
            return this.and();
        }
    }

    public class InitContainerStatusesNestedImpl<N>
    extends ContainerStatusFluentImpl<PodStatusFluent.InitContainerStatusesNested<N>>
    implements PodStatusFluent.InitContainerStatusesNested<N>,
    Nested<N> {
        private final ContainerStatusBuilder builder;
        private final int index;

        InitContainerStatusesNestedImpl(int index, ContainerStatus item) {
            this.index = index;
            this.builder = new ContainerStatusBuilder(this, item);
        }

        InitContainerStatusesNestedImpl() {
            this.index = -1;
            this.builder = new ContainerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodStatusFluentImpl.this.setToInitContainerStatuses(this.index, this.builder.build());
        }

        @Override
        public N endInitContainerStatus() {
            return this.and();
        }
    }

    public class EphemeralContainerStatusesNestedImpl<N>
    extends ContainerStatusFluentImpl<PodStatusFluent.EphemeralContainerStatusesNested<N>>
    implements PodStatusFluent.EphemeralContainerStatusesNested<N>,
    Nested<N> {
        private final ContainerStatusBuilder builder;
        private final int index;

        EphemeralContainerStatusesNestedImpl(int index, ContainerStatus item) {
            this.index = index;
            this.builder = new ContainerStatusBuilder(this, item);
        }

        EphemeralContainerStatusesNestedImpl() {
            this.index = -1;
            this.builder = new ContainerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodStatusFluentImpl.this.setToEphemeralContainerStatuses(this.index, this.builder.build());
        }

        @Override
        public N endEphemeralContainerStatus() {
            return this.and();
        }
    }

    public class ContainerStatusesNestedImpl<N>
    extends ContainerStatusFluentImpl<PodStatusFluent.ContainerStatusesNested<N>>
    implements PodStatusFluent.ContainerStatusesNested<N>,
    Nested<N> {
        private final ContainerStatusBuilder builder;
        private final int index;

        ContainerStatusesNestedImpl(int index, ContainerStatus item) {
            this.index = index;
            this.builder = new ContainerStatusBuilder(this, item);
        }

        ContainerStatusesNestedImpl() {
            this.index = -1;
            this.builder = new ContainerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodStatusFluentImpl.this.setToContainerStatuses(this.index, this.builder.build());
        }

        @Override
        public N endContainerStatus() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends PodConditionFluentImpl<PodStatusFluent.ConditionsNested<N>>
    implements PodStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final PodConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, PodCondition item) {
            this.index = index;
            this.builder = new PodConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new PodConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

