/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_13.handlers;

import io.fabric8.kubernetes.api.model.v4_13.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v4_13.ListOptions;
import io.fabric8.kubernetes.clnt.v4_13.Config;
import io.fabric8.kubernetes.clnt.v4_13.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_13.Watch;
import io.fabric8.kubernetes.clnt.v4_13.Watcher;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_13.dsl.Resource;
import io.fabric8.openshift.api.model.v4_13.APIServer;
import io.fabric8.openshift.api.model.v4_13.APIServerBuilder;
import io.fabric8.openshift.clnt.v4_13.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_13.dsl.internal.APIServerOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class APIServerHandler
implements ResourceHandler<APIServer, APIServerBuilder> {
    @Override
    public String getKind() {
        return APIServer.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "config.openshift.io/v1";
    }

    @Override
    public APIServer create(OkHttpClient client, Config config, String namespace, APIServer item) {
        return (APIServer)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new APIServer[0]);
    }

    @Override
    public APIServer replace(OkHttpClient client, Config config, String namespace, APIServer item) {
        return (APIServer)((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public APIServer reload(OkHttpClient client, Config config, String namespace, APIServer item) {
        return (APIServer)((Gettable)((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public APIServerBuilder edit(APIServer item) {
        return new APIServerBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, APIServer item) {
        return (Boolean)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, APIServer item, Watcher<APIServer> watcher) {
        return (Watch)((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, APIServer item, String resourceVersion, Watcher<APIServer> watcher) {
        return (Watch)((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, APIServer item, ListOptions options, Watcher<APIServer> watcher) {
        return (Watch)((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public APIServer waitUntilReady(OkHttpClient client, Config config, String namespace, APIServer item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (APIServer)((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public APIServer waitUntilCondition(OkHttpClient client, Config config, String namespace, APIServer item, Predicate<APIServer> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (APIServer)((Resource)new APIServerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

